proc(o)=sijci(yp,dy,ord,b,e,t,di,i,j);
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  modelci
; ----------------------------------------------------------------------
;   Macro	  sijci
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for cointegration
; ----------------------------------------------------------------------
;   Usage         o=sijci(yp,dy,ord,b,e,t,di,i,j)
;   Input 
;     Parameter   yp 
;     Definition     matrix, submatrix of time series
;     Parameter   dy 
;     Definition     matrix, differenced time series
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   b 
;     Definition     matrix 
;     Parameter   e 
;     Definition     vector 
;     Parameter   t 
;     Definition     vector, number of observations
;     Parameter   di 
;     Definition     integer, dimension of time series
;     Parameter   i 
;     Definition     integer 
;     Parameter   j 
;     Definition     integer 
;   Output
;     Parameter   o
;     Definition     matrix 
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Stefan Sperlich 971215
; ---------------------------------------------------------------------- 
   if (i==0)
    ri=rici(dy[,b:e],dy,ord,b,e,di)
  else
    ri=rici(yp,dy,ord,b,e,di);
  endif;
  if (i==j) 
    ri=ri*ri';
  else;
    if (i==0)
       ri=ri *  rici(yp,dy,ord,b,e,di)';
    else;    
       ri=ri *  rici(dy[,b:e],dy,ord,b,e,di)';
    endif;
  endif;
  o=ri/t
endp;
