library("glm")
proc(simexl,simexq)=simex(y,w,z,su2,lam,b)
; -----------------------------------------------------------------
;    Library	eiv
; -----------------------------------------------------------------
;    See_also	reca
; -----------------------------------------------------------------
;    Macro	simex
; -----------------------------------------------------------------
;    Description    SIMEX (SIMulation EXtrapolation) is a simulation-based
;		    method of estimating and reducing bias due to measurement
;		    error. simex is applicable to general estimation methods,
;		    for example, least-squares, maximum likelihood,
;		    quasi-likelihood, etc.
; ----------------------------------------------------------------------------
;   Reference	 The 5th and 6th chapters of Carroll, R.J., Ruppert, D. and 
;              Stefanski, L.A. (1995): Nonlinear Measurement Error Models.
;              Chapman and Hall, New York.
; -----------------------------------------------------------------
;    Link	  ../tutorials/eivstart.html Tutorial: EIV in XploRe
; -----------------------------------------------------------------
;    Usage    {simexl,simexq} = simex(y, w, z, su2, lam, b)
;    Input
;      Parameter  y
;      Definition   n x 1 matrix, the design variables
;      Parameter  w
;      Definition   n x 1 matrix, surrogate variable of unobservable variable
;      Parameter  z
;      Definition   n x 1 matrix, covariate measured without error
;      Parameter  su2
;      Definition the variance of the measurement error
;      Parameter  lam
;      Definition  pseudo-parameter for generating pseudo-errors
;      Parameter  b
;      Definition the number of replication in each simulation
;    Output
;      Parameter  simexl
;      Definition the estimate based on linear extrapolant function
;      Parameter  simexq
;      Definition the estimate based on quadratic extrapolant function
; -----------------------------------------------------------------
;  Example library("xplore")
;	   library("eiv")
;	   n=100
;	   randomize(n)
;	   y=floor(uniform(n)+0.3)
;	   w=uniform(n)^2
;	   z=floor(uniform(n)+0.45)
;	   su2=var(w)/4
;	   lam=aseq(0.01,6,0.5)
;	   b=20
;	   gest=simex(y,w,z,su2,lam,b)
;	   gest.simexl
;	   gest.simexq
; -----------------------------------------------------------------
;    Result  Contents of simexl
;            [1,]  -2.2569  0.92894  0.90323
;            Contents of simexq
;            [1,]  -2.265   0.95407  0.90822
; -----------------------------------------------------------------
;   Author    Hua Liang,  970818
; -----------------------------------------------------------------
;
;   The simulation procedure
;
     g=glmest("bilo",matrix(rows(w))~w~z,y)
     bet1=g.b'
     i=1
     while(i<=(rows(lam)))
       j=1
       bets=0*matrix(cols(matrix(rows(w))~w~z),b)
       while(j<=b)
	wn=w+sqrt(lam[i]*su2)*normal(rows(w),1)
	g1=glmest("bilo",matrix(rows(w))~wn~z,y)
	bets[,j]=g1.b
	j=j+1
       endo
       bet1=bet1|(mean(bets,2))'
       i=i+1
     endo
;
;  The extrapolation procedure
;
   lxd0=(lam.=lam)~lam
   lxd=#(1,0)'|lxd0
   qxd0=lxd0~(lam^2)
   qxd=#(1,0,0)'|qxd0
   gam1=inv(lxd'*lxd)*lxd'*bet1
   gamq=inv(qxd'*qxd)*qxd'*bet1
   simexl=gam1[1,]-gam1[2,]
   simexq=gamq[1,]-gamq[2,]+gamq[3,]
endp
