proc(r,s) = stointpm(aIh, b, N)

; -----------------------------------------------------------------
; Library        kalman
; -----------------------------------------------------------------
;  See_also      rICfil, calibrIC, ICerzsep
; -----------------------------------------------------------------
;   Macro        stointpm
; -----------------------------------------------------------------
;   Description  Auxiliary routine for rICfil:
;                calculates for dimension p>(=)2
;                (E[ YY'  u min(b/|aIhY|,u) ])
;   and          (E[ YY'   min(b/|aIhY|,u)^2 ])
;                for u square root of a Chi^2_p-variable, 
;                and Y~ufo(S_2) indep of u
;                by using a polar representation of
;                Lambda:= I^{1/2} Y u,  u = | I^{-1/2} Lambda |, 
;                Y=I^{-1/2} Lambda /u.
; 
;                The integrals are evaluated stepwise, first conditioning on Y
;                and calculated "analytically" using Ewinn, Ew2inn
;                and then the outer integration is done by MC-Integration
;                along the directions Y, parametrized by a 
;                sin-cos-representation.
; -----------------------------------------------------------------
;   Keywords     robust Kalman filter, rIC
; -----------------------------------------------------------------
;   Usage          {r,s}=stointpm     (aIh,b,N)
;   Input
;     Parameter   aIh
;     Definition  dim: pxp; .  A I^{1/2}, I FisherInfo; [sym. pos.semi.def!]
;     Parameter   b
;     Definition     numeric; clipping height; >0
;     Parameter   N
;     Definition     numeric; sample size for MC-Integration
; Output                                                           
;     Parameter   r
;     Definition  p x p-dim; r=(E[ YY'  u min(b/|aIhY|,u) ])
;     Parameter   s
;     Definition  p x p-dim; s=(E[ YY'  min(b/|aIhY|,u)^2 ])
; -----------------------------------------------------------------
; Notes
;     Not to be used outside of rICfil!
; 
;      Is called by iteras.
; 
;      Calles [within kalman.lib]  ew2inn ewinn.
; -----------------------------------------------------------------
;   Example   to be looked up in rICfil
; -----------------------------------------------------------------
;   Author    P.Ruckdeschel 991010 
; -----------------------------------------------------------------

   
p=rows(aIh)

Y=matrix(p,N); will be filled by N Variable Y[,i]~ufo(S_p)

X=uniform(p-1,N)*pi
X[1,]=X[1,]*2


C=cos(X)
S=sin(X)

Yp=1;          p-th  coordinate of Y
jacob=1;       jacobian for integration along S_p
p3=1

if ((p%2)==0)
    pp=2*pi
    p2=0
else
    pp=2
    p2=1
endif

i=1
while (i<=p-1)
     if ((i+p2)%2==0)
	 pp=pp*2*pi/i
     endif
     p3=p3*pi
     jacob=jacob.*S[i,]^(i-1)
     Y[i,]=Yp.*C[p-i,]
     Yp=Yp.*S[p-i,]
     i=i+1
endo

p3=p3*2
Y[p,]=Yp

eins=0*matrix(p)+1
aiY=aIh*Y
aiYn=sqrt(sum(aiY^2,1))
aiYn=aiYn.*(aiYn>0)+(aiYn==0).*0.03
c=b/aiYn

ri=ewinn(c,p)
si=ew2inn(c,p)

ri=reshape(ri,#(1,1,N))
si=reshape(si,#(1,1,N))
Y=reshape(Y,#(p,1,N))

jacob=reshape(jacob,#(1,1,N))

intgrd1=Y*Y'.*ri.*jacob.*p3/pp
intgrd2=Y*Y'.*si.*jacob.*p3/pp

r=mean(intgrd1,3)
s=mean(intgrd2,3)

endp
