proc(a)=taills(x,m)
; ----------------------------------------------------------------------
; Library 	  finance
; ----------------------------------------------------------------------
;  See_also	  hill
; ----------------------------------------------------------------------
;   Macro	  taills
; ----------------------------------------------------------------------
;   Description   Estimates the tail index of fat-tailed distributions
; ----------------------------------------------------------------------
;   Usage         a = taills(x,m)
;   Input
;     Parameter   x
;     Definition  (n*p) matrix
;     Parameter   m
;     Definition  scalar
;   Output
;     Parameter   a
;     Definition  p-vector giving for each column of x the Phillips Loretan
;                 least squares estimate of the tail index 
; ---------------------------------------------------------------------
;  Reference      Phillips,P.C.B., Loretan, M. (1990): Testing Covariance
;                 Stationarity under moment condition failure with an 
;                 application to common stock returns, Cowles Foundation
;                 DP 947.
; ---------------------------------------------------------------------
;  Keywords       tail index
; ----------------------------------------------------------------------
;   Example       library("times")
;                 randomize(0)
;                 x=normal(1000,2)
;                 taills(x,10)
; ----------------------------------------------------------------------
;   Result        Contents of a 
;                 [1,]   3.467 
;                 [2,]   6.4243  
; ----------------------------------------------------------------------
;   Author        Christian Hafner, 981110
; ----------------------------------------------------------------------
n=rows(x)
k=cols(x)
a=matrix(k,1)
x=x-mean(x)
error(min(sum(x.>0))<m,"Row dimension too small !")
i=1
while(i<=k)
  x=sort(x,(-i))
  g=gls(matrix(m,1)~log(x[1:m,i]),log((1:m)/n))
  a[i,]=-g[2,] 
  i=i+1
endo
endp
