proc(rotm,tourparam)=tourrandom(tourparamin, rm)
; -----------------------------------------------------------------------
; Library      pp
; -----------------------------------------------------------------------
; See_also     plotgt
; -----------------------------------------------------------------------
; Macro        tourrandom
; -----------------------------------------------------------------------
; Description  Computes a random rotation matrix.
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 971112
; -----------------------------------------------------------------------
  tourparam = tourparamin
  if (tourparam.tr>=sum(abs(tourparam.tra)))
    tourparam.trrot = rm
    p    = rows(rm)
    rotm = orthonormal(normal(p, p))
    rotm = rotm*inv(rm)
    tourparam.tra = mat2rot(rotm)    
    tourparam.tr = 0
    ; sum(abs(tourparam.tra))
  endif
  tourparam.tr = tourparam.tr+200*tourparam.trdt
  q = min(tourparam.tr/sum(abs(tourparam.tra))|1)
  rotm = rot2mat(q*tourparam.tra)*tourparam.trrot 
endp
