proc(xt)=trimper(x,perc)
; -----------------------------------------------------------------
; Library        metrics
; -----------------------------------------------------------------
;  See_also      adeind adeslp
; -----------------------------------------------------------------
;   Macro        trimper
; -----------------------------------------------------------------
;   Keywords     trimming, binning
; -----------------------------------------------------------------
;   Description  trims a given percentage of a (binned) data matrix
; -----------------------------------------------------------------
;   Usage        xt = trimper(x,perc)    
;   Input
;     Parameter   x  
;     Definition      n x d matrix , the data matrix
;                                    In the first row the values according 
;                                    to which the trimming should be done 
;                                    are expected. The second row should contain ;                                    the frequency count for the values in the    ;                                    first row.
;     Parameter   perc 
;     Definition      scalar , the percentage of data points which should
;                              be trimmed maximal
;   Output                                                                   
;     Parameter   xt
;     Definition      l x d matrix , the trimmed data matrix
; -----------------------------------------------------------------
;   Example   library("metrics")
;             perc = 5
;             x = 1:100 
;             x = x~matrix(rows(x),1)
;             xt = trimper(x,perc)
;             xt 
; -----------------------------------------------------------------
;   Result    trimmed (and binned) data matrix            
; -----------------------------------------------------------------
;   Author    Sperlich & Stockmeyer 951111  
; -----------------------------------------------------------------

  n  = rows(x)
  xt = x[,1:2]~aseq(1,n,1)
  xt = sort(xt, 1|2|3 )
  indt  = cumsum(xt[,2])
  trhold= indt[n]*perc/100
  indt = indt.>trhold
  indt = xt[,3]~indt
  indt = sort(indt)
  indt = indt[,2]
  xt = paf(x,indt)
endp
