proc()=twboxcox(x)
; -----------------------------------------------------------------------
; Library      tware  
; -----------------------------------------------------------------
; See_also     hinesplot boxcox boxcoxdens
; -----------------------------------------------------------------------
; Macro        twboxcox
; -----------------------------------------------------------------------
; Description  allows to find interactively the best parameter for your
;              data for a Box-Cox transformation.
; -----------------------------------------------------------------------
; Usage        twboxcox(x)
; Input
;   Parameter  x
;   Definition n x q 
; -----------------------------------------------------------------------
; Example      ; loads the library stats
;              library("tware")   
;              ; loads the library smoother
;              library("smoother")   
;              ; reset random generator 
;              randomize(0)
;              ; generate x
;              x = normal(200)
;              x = x.*x
;              ; find interactively a best transformation
;              twboxcox (x)
; -----------------------------------------------------------------------
; Author       Susanne Hannappel, 970220 
;              Sigbert Klinke, 970820
; -----------------------------------------------------------------------
  twboxcoxloop(x)
  headline = ("Do you want to start again?") 
  items = "yes" | "no" 
  i = selectitem(headline, items, "single") 
  while (sum(i==#(1,0)>0))
    if (sum(i==#(1,0))==1)
      headline = ("Choose exactly one option! Do you want to start again?") 
      items = "yes" | "no" 
      i = selectitem(headline, items, "single") 
    endif 
    if (sum(i==#(1,0))==2)
      twboxcoxloop(x)
      headline = ("Do you want to start again?") 
      items = "yes" | "no" 
      i = selectitem(headline, items, "single")   
    endif
  endo
endp
