proc(uselret)=twles3(usel)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     twles1 twles2 twles4 twles5 twles6 twles7 twles8
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        twles3
; -----------------------------------------------------------------------
; Description  Compares the approximation of sines with different 
;              frequencies by wavelets.
;              You can choose between different wavelet base, different 
;              number of father wavelet coefficients and different views 
;              to the mother wavelet coefficients.
; -----------------------------------------------------------------------
; Usage        twles3(NaN)
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960912
; -----------------------------------------------------------------------
  if (existglobal("DisplaySize"))
    ds = getglobal("DisplaySize")
  else
    ds = 400
  endif
  setsize (2*ds, ds)
  d3 = createdisplay(2,2)
  n = 128
  {tmp, x1} = chfunc (NaN, 0, n, #(0,0,1,0))
  {tmp, x2} = chfunc (NaN, x1, n, #(0,0,4,0))
  h = getglobal ("daubechies4")
  l = 4
  v = 1
  {a1, b1} = fwt (x1, l, h)
  {a2, b2} = fwt (x2, l, h)
  selhead = "Wavelet lesson 3"
  selitem = "Change basis"|"Change level"|"Change view"|"Print"
  end = 0
  do
    if (v.=1)
      waveint1b (d3, 1, a1, b1, x1, 1)
      waveint1b (d3, 2, a2, b2, x2, 1)
    endif
    if (v.=2)
      waveint3b (d3, 1, a1, b1, x1, 1)
      waveint3b (d3, 2, a2, b2, x2, 1)
    endif
    if (v.=3)
      waveint2b (d3, 1, a1, b1, x1, 1, b1)
      waveint2b (d3, 2, a2, b2, x2, 1, b2)
    endif
    if (v.=4)
      waveint4b (d3, 1, a1, b1, x1, 1, l, h)
      waveint4b (d3, 2, a2, b2, x2, 1, l, h)
    endif
    ru = rows(usel)
    if (ru.>1)
      sel  = (usel[2].=(1:4))
      if (ru.>2)
        usel = usel[1]|usel[3:ru]
      else
        usel = usel[1]
      endif
    else
      sel = selectitem (selhead, selitem)
    endif
    end = sum(sel).=0
    if (sel[1])
      {usel, h} = chbase (usel, h)
      {a1, b1} = fwt (x1, l, h)    
      {a2, b2} = fwt (x2, l, h)
    endif
    if (sel[2])
      ru = rows(usel)
      if (ru.>1)
        l = usel[2]
        if (ru.>2)
          usel = usel[1]|usel[3:ru]
        else
          usel = usel[1]
        endif
      else
        do
          l = readvalue ("Change level", l)
        until ((l>3) && (l<rows(x1)))
      endif
      l = 2^floor(log(l)./log(2))
      {a1, b1} = fwt (x1, l, h)    
      {a2, b2} = fwt (x2, l, h)
    endif  
    if (sel[3])
      {usel, v} =chview(usel, v)
    endif
    if (sel[4])
      usel = twprint(d3, usel)
    endif
  until (end)
  uselret = usel
endp
