proc(uselret)=twles6(usel)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     twles1 twles2 twles3 twles4 twles5 twles7 twles8
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        twles6
; -----------------------------------------------------------------------
; Description  Shows how a soft threshold behaves on the true function
;              and the true function plus noise.
;              You can choose between different wavelet base, different 
;              number of father wavelet coefficients, different functions
;              different views to the mother wavelet coefficients, 
;              soft threshold by hand and automatically.
; -----------------------------------------------------------------------
; Usage        twles6()
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960912
; -----------------------------------------------------------------------
  if (existglobal("DisplaySize"))
    ds = getglobal("DisplaySize")
  else
    ds = 400
  endif
  setsize (2*ds, ds)
  d6 = createdisplay(2,2)
  n = 128
  {tmp, x1} = chfunc (NaN, 0, n, #(0,0,0,1))
  dev = 0.3 
  randomize(0)
  x2 = x1+dev*normal(n)
  h = getglobal ("daubechies4")
  l = 4
  v = 3
  {a1, b1} = fwt (x1, l, h)
  {a2, b2} = fwt (x2, l, h)
  selhead = "Wavelet lesson 6"
  selitem = "Change basis"|"Change level"|"Change function"|"Change view"|"Noise level"|"Soft Threshold"|"Automatic"|"Adaptive"|"Print"
  end = 0
  bt1 = b1
  bt2 = b2
  do
    if (v.=1)
      waveint1b (d6, 1, a1, bt1, x1, 1)
      waveint1b (d6, 2, a2, bt2, x2, 1)
    endif
    if (v.=2)
      waveint3b (d6, 1, a1, bt1, x1, 1)
      waveint3b (d6, 2, a2, bt2, x2,1 )
    endif
    if (v.=3)
      waveint2b (d6, 1, a1, bt1, x1, 1, b1)
      waveint2b (d6, 2, a2, bt2, x2, 1, b2)
    endif
    if (v.=4)
      waveint4b (d6, 1, a1, bt1, x1, 1, l, h)
      waveint4b (d6, 2, a2, bt2, x2, 1, l, h)
    endif
    ru = rows(usel)
    if (ru.>1)
      sel  = (usel[2].=(1:9))
      if (ru.>2)
        usel = usel[1]|usel[3:ru]
      else
        usel = usel[1]
      endif
    else
      sel = selectitem (selhead, selitem)
    endif
    end = sum(sel).=0
    if (sel[1])
      {usel, h} = chbase (usel, h)
      {a1, b1} = fwt (x1, l, h)  
      {a2, b2} = fwt (x2, l, h)
      bt1 = b1
      bt2 = b2 
    endif
    if (sel[2])
      ru = rows(usel)
      if (ru.>1)
        l    = usel[2]
        if (ru.>2)
          usel = usel[1]|usel[3:ru]
        else
          usel = usel[1]
        endif
      else
        do
          l = readvalue ("Change level", l)
        until ((l>3) && (l<rows(x1)))
      endif
       l = 2^floor(log(l)./log(2))
      {a1, b1} = fwt (x1, l, h)  
      {a2, b2} = fwt (x2, l, h)
      bt1 = b1
      bt2 = b2 
    endif  
    if (sel[3])
      {usel, x1} = chfunc(usel, x1, n, 0)
      randomize(0)
      x2 = x1+dev*normal(n)
      {a1, b1} = fwt (x1, l, h)
      {a2, b2} = fwt (x2, l, h)
      bt1 = b1
      bt2 = b2
   endif
    if (sel[4])
      {usel, v} = chview (usel, v)
    endif
    if (sel[5])
      ru = rows(usel)
      if (ru.>1)
        dev = usel[2]
        if (ru.>2)
          usel = usel[1]|usel[3:ru]
        else
          usel = usel[1]
        endif
      else
        dev = readvalue ("Deviation:", dev)
      endif
      randomize(0)
      x2 = x1+dev*normal(n)
      {a2, b2} = fwt (x2, l, h)
      bt1 = b1
      bt2 = b2 
    endif
    if (sel[6])
      {usel, bt2, bt1} = softthres (usel, b2, b1, x2)
      x1 = invfwt(a1, bt1, n, l, h)
      x2 = invfwt(a2, bt2, n, l, h)
    endif
    if (sel[7])
      {bt2, bt1} = softauto (b2, b1, x2)
      x1 = invfwt(a1, bt1, n, l, h)
      x2 = invfwt(a2, bt2, n, l, h)
    endif
    if (sel[8])
      {bt2, bt1} = softadap(b2, b1, x2)
      x1 = invfwt(a1, bt1, n, l, h)
      x2 = invfwt(a2, bt2, n, l, h)
    endif
    if (sel[9])
      usel = twprint (d6, usel)
    endif
  until (end)
  uselret = usel
endp
