proc(uselret)=twles8(usel)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     twles1 twles2 twles3 twles4 twles5 twles6 twles7
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        twles8
; -----------------------------------------------------------------------
; Description  Shows the father and mother wavelet for a given basis.
;              You can choose between different wavelet base.
; -----------------------------------------------------------------------
; Usage        twles8(NaN)
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960912
; -----------------------------------------------------------------------
  if (existglobal("DisplaySize"))
    ds = getglobal("DisplaySize")
  else
    ds = 400
  endif
  setsize (ds, ds)
  d8 = createdisplay(1,1) 
  n = 512
  h = getglobal("daubechies4")
  p = ceil(log(2*rows(h)-1)./log(2))-1
  l = 2^p
  a = 0~0
  i = l+l/2-1
  b = p~(l/2-1)~1
  f = invfwt(a, b, n, l, h)
  t = ((1:n)-0.5)./n
  f = t~f
  setmaskp (f, 0, 0, 0)
  setmaskl (f, (1:n)', 0, 1, 3)
  selhead = "Wavelet lesson 8"
  selitem = "Change basis"|"Father"|"Mother"|"Change level"|"Change index"|"Print"
  end = 0
  l = 4
  do
    show (d8, 1, 1, f)
    ru = rows(usel)
    if (ru.>1)
      sel  = (usel[2].=(1:6))
      if (ru.>2)
        usel = usel[1]|usel[3:ru]
      else
        usel = usel[1]
      endif
    else
      sel = selectitem (selhead, selitem)
    endif
    end = sum(sel).=0
    if (sel[1])
      {usel, h} = chbase (usel, h)
      p = ceil(log(2*rows(h)-1)./log(2))-1
      l = 2^p
      a = 0~0
      i = l+l/2-1
      b = p~(l/2-1)~1
      f = invfwt(a, b, n, l, h)
      t = ((1:n)-0.5)./n
      f = t~f
      setmaskp (f, 0, 0, 0)
      setmaskl (f, (1:n)', 0, 1, 3)
    endif
    if (sel[2])
      p = ceil(log(2*rows(h)-1)./log(2))-1
      l = 2^p
      a = (l/2-1)~1
      b = 0~0~0
      i = l/2-1
      f = invfwt(a, b, n, l, h)
      t = ((1:n)-0.5)./n
      f = t~f
      setmaskp (f, 0, 0, 0)
      setmaskl (f, (1:n)', 0, 1, 3)
    endif
    if (sel[3])
      p = ceil(log(2*rows(h)-1)./log(2))-1
      l = 2^p
      a = 0~0
      b = p~(l/2-1)~1
      i = l+l/2-1
      f = invfwt(a, b, n, l, h)
      t = ((1:n)-0.5)./n
      f = t~f
      setmaskp (f, 0, 0, 0)
      setmaskl (f, (1:n)', 0, 1, 3)
    endif
    if (sel[4])
      ru = rows(usel)
      if (ru.>1)
        l    = usel[2]
        if (ru.>2)
          usel = usel[1]|usel[3:ru]
        else
          usel = usel[1]
        endif
      else
        do
          l = readvalue ("Change level", l)
        until ((l>3) && (l<n))
      endif
      l = 2^floor(log(l)./log(2))
      i = 0
      a = i~1
      b = 0~0~0
      f = invfwt(a, b, n, l, h)
      t = ((1:n)-0.5)./n
      f = t~f
      setmaskp (f, 0, 0, 0)
      setmaskl (f, (1:n)', 0, 1, 3)
    endif
    if (sel[5])
      ru = rows(usel)
      if (ru.>1)
        i    = usel[2]
        if (ru.>2)
          usel = usel[1]|usel[3:ru]
        else
          usel = usel[1]
        endif
      else
        do
          i = readvalue ("Change index", i)
        until ( ((i.>-1) && (i.<n)) )
      endif
      if (i.<l)
        a = i~1
        b = 0~0~0
      else
        a = 0~0
        b  = floor(log(i)./log(2))
        b  = b~(i-2^b)~1
      endif 
      f = t~invfwt(a, b, n, l, h)
      setmaskp (f, 0, 0, 0)
      setmaskl (f, (1:n)', 0, 1, 3)
    endif
    if (sel[6])
      usel = twprint (d8, usel)
    endif
  until (end)
  uselret = usel
endp
