proc()=twtest(val)
; -------------------------------------------------------------------------------
;   Library      tware
; -------------------------------------------------------------------------------
;   See_also     twpvalue, tw1d, twrandomsample, twnormalize, twclt, twpearson, twlinreg, twskew
; -------------------------------------------------------------------------------
;   Macro        twtest
; -------------------------------------------------------------------------------
;   Description  teachware quantlet
;                shows error type I and II in testing simple hypotheses
; -------------------------------------------------------------------------------
;   Usage        twtest({val})
;   Input        val  vector(5x1)
; -------------------------------------------------------------------------------
;   Example      ; load teachware library
;                library("tware")
;                ; predefinition of default values
;                val=20 | 100 | 105 | 9 | 0.05
;                ; call test teachware example
;                twtest(val)
; -------------------------------------------------------------------------------
;   Result       plots teststatistics under H_0 and H_1, calculates type I and II error
; -------------------------------------------------------------------------------
;   Link         
; -------------------------------------------------------------------------------
;    Author      RJ 000906
; -------------------------------------------------------------------------------
if (exist(val)<>1)
  val=20 | 100 | 105 | 9 | 0.05  ; default values
endif
val=readvalue("Sample size n"|"mean1"|"mean2"|"standard deviation"|"alpha",val)
error(val[1]<0,"Negative argument!")
error(val[2]>val[3],"mean1 should be set less than mean2")
error((val[5]<=0)||(val[5]>=1),"significance level out of range")
error(val[4]<=0,"Standard deviation must be positive")
sigma=val[4]/sqrt(val[1]) ; standard deviation of x-bar
;plot of densities
xmin=min((val[2]-3.5*sigma)|(val[3]-3.5*sigma))
xmax=max((val[2]+3.5*sigma)|(val[3]+3.5*sigma))
n=100
x=xmin+(xmax-xmin)/(n-1) .* (0:n-1)
y1=pdfn((x-val[2])/sigma)/sigma
y2=pdfn((x-val[3])/sigma)/sigma
z3=setmask(x~y1, "line", "green")
z2=setmask(x~y2, "line", "red")
critval=val[2]+sigma*qfn(1-val[5])
;shading areas of error type I and II
counter=800
pea=0*((1:5) .* (1:counter)')
while (counter>0)
pea[,counter]=((xmin + (critval-xmin)*counter/800)~(pdfn((xmin + (critval-xmin)*counter/800-val[3])/sigma)/sigma)~0~(critval + (xmax-critval)*counter/800)~(pdfn((critval + (xmax-critval)*counter/800-val[2])/sigma)/sigma))
counter=counter-1
endo 
z1=setmask(vec(pea[(1|1),])~vec(pea[(2:3),]), "line", "red") ; shading area of type II error
z4=setmask(vec(pea[(4|4),])~vec(pea[(5|3),]), "line", "green") ; shading area of type I error
z5=grxline(critval, y1, "black") ; reference line for critical value
beta=cdfn((critval-val[3])/sigma) ; calculation of error type II
  disp = createdisplay(2,1)
if (val[5]<beta) ;necessary to decide whether red line on green area or vice versa
  show (disp, 1, 1, z1,z2,z3,z4,z5)
  else
  show (disp, 1, 1, z1,z4,z3,z2,z5)
endif
  show (disp, 2, 1, string("Black reference line displays the critical value of %2.2f.", critval)|string("Type I error (green shaded area) is %2.4f,", val[5])|string("type II error (red shaded area) is %2.4f.", beta))
title = "Distribution of test-statistic under H_0 and H_1"
setgopt(disp,1,1,"title",title)
endp
