proc(x)=unit(d)
; -----------------------------------------------------------------
;   Library       xplore
; -----------------------------------------------------------------
;   See_also      diag xdiag matrix
; -----------------------------------------------------------------
;   Keywords      matrix
; -----------------------------------------------------------------
;   Macro         unit
; -----------------------------------------------------------------
;   Description   Calculates a d-dimensional identity matrix.
; -----------------------------------------------------------------
;   Usage         x = unit(d)
;   Input
;     Parameter   d
;     Definition      integer
;   Output
;     Parameter   x
;     Definition      d-dimensional unit matrix
; -----------------------------------------------------------------
;   Example   library("xplore")
;             unit(3)
; -----------------------------------------------------------------
;   Result 
;             Contents of x
;             [1,]   1   0   0 
;             [2,]   0   1   0 
;             [3,]   0   0   1 
; -----------------------------------------------------------------
;   Author    ChristopherKath  970608.1000
; -----------------------------------------------------------------
  x=diag(matrix(d))  
endp


