; Hilfsroutinen
;
proc (s) = sign (x)
     switch
     case (x<0)  y = -1  break
     case (x>0)  y =  1  break
     default     y =  0  break   ; this break has no effect
     endsw
endp
;
proc(j)=factorial1(x)
     if (x>1)
     j=1
     do 
     j=j*x
     x=x-1
     until (x<2)
     else 
     j=x
     endif
endp
;
proc(j)=factorial2(x)
     if (x>1)
     j=1
     while (x>=2)
     j=j*x
     x=x-1
     endo
     else 
     j=x
     endif
endp
;
proc(y)=abso(x)
     if (x<0)
     y=-1.0*x
     else
     y=x
     endif
endp
;
proc () = plot (z, d)
     if (comp("z", "x")*comp("z", "y"))
     show (d, 1, 1, z.x~z.y)
     endif
endp
;
proc (y) = f(x)
     y = sum((x-2)^2)    
endp
;
proc (y) = df (x)
     y = 2*(x-2)    
endp
;
proc (y) = f2 (x)
     y = sum(x^2)    
endp
;
; Testroutinen
;
proc()=nonpara()
"Nonparametric Methods"
; sker
     library("kernel")        ; loading the quartic kernel
     x = 2.*uniform(100)-1
     x = sort(x)
     y = 5*x^2+0.5*normal(100)
     d = createdisplay(1,1)
     ;
     rs = sker (x, 0.25, "qua", y)
     fs = sker (x, 0.25, "qua", matrix(100))
     mh = rs./fs                ; nadaraya-watson estimator on x
     show(d, 1, 1, x~y, x~mh)
     ; continuing using xest
     xest = 2.*(0:100)/100-1
     rs = sker (x, 0.25, "qua", y, xest)
     fs = sker (x, 0.25, "qua", matrix(100), xest)
     mh = rs./fs                ; nadaraya-watson estimator on xest
     show(d, 1, 1, x~y, xest~mh)
endp
;
proc()=bingridse()
"Binning, Grids and Sequences"
; bindata
; conv
; grid
     randomize(0)
     x = normal (100,2)
     {xb,yb} = bindata(x, #(0.25,0.25),#(0,0))
     library("kernel") 
     x = #(0,0)
     h = #(0.25,0.25)
     n = #(5,5)
     wx= grid(x,#(1,1),n)
     wy = qua(wx.*h) 
     {xc, yc, fill} = conv (xb, yb, wx, wy)
     cc=createdisplay(1,1)
     show (cc,1,1,xc ~ yc)
endp
;
proc()=flowcont()
"Flow control"
; switch
; case
; break
; default
; endsw
  sign(1)
  sign(-1)
  sign(0)
; do
; until
; endo
; while
  factorial1(10)
  factorial2(10)
; if
; else
; endif
  abso(1)
  abso(-1)
endp
;
proc()=guifunc()
"GUI functions"
; readvalue
     valuestrs="x=" | "y=" | "z="
     values=0 | 0 | 0
     v=readvalue(valuestrs, values)
; selectitem
     headline="Please select"
     items="linear" | "quadratic" | "log"
     i=selectitem(headline, items)
endp
;
proc()=infocon()
"Information and Control"
; comp
     d = createdisplay (1,1)
     x = (1:100)/100
     y = x^2
     a = list (x, y)
     plot (a, d)
; edit
     x=diag(matrix(4))
     edit(x)
; editmac
     editmac("factorial1")
; exec
     a="reshape((1:4),#(2,2))"
     exec(a)
; existglobal
     e = existglobal ("eulerc")
; free
;   not allowed in macros
;     x=matrix(3,3)
;     free("x")
; getenv
     getenv ("xpl4home")
; getglobal
     x = getglobal ("eulerc")
; putglobal
     x = 7
     putglobal ("x")
; setenv
     setenv ("format", "%10.2f")
endp
;
proc()=linalg()
"Linear Algebra"
; '
     x = #(1,2)~#(3,4)~#(5,6)
     x
; det
     x=#(1,0)~#(0,1)
     det (x)
; distance
     x = #(1,4)~#(1,5)
     distance (x, "l1")
     distance (x, "l2")
     distance (x, "maximum")
; eigsm
     x=#(1,3)~#(3,1)
     eigsm(x)
; inv
     x = #(1,2)~#(3,4)
     inv (x)
; ludecomp
     x = #(1, 2, 3)~#(2, 3, 4)~#(3, 4, 5)
     z = ludecomp (x)
     z
     index(z.l*z.u, z.index)
; trans
     x = #(1,2)~#(3,4)~#(5,6)
     trans (x)
endp
;
proc()=mathfun()
"Mathematical functions"
; acos
     x = #(0, 1/sqrt(2))~#(-1, -1/sqrt(2))
     acos (x)
; acosh
     x = #(1, 2)~#(3, 4)
     acosh (x)
; asin
     x = #(1, 1/sqrt(2))~#(0, 1/sqrt(2))
     asin(x)
; asinh
     x = #(0, 2)~#(3, 4)
     asinh(x)
; atan
     x = #(sqrt(3), 1)~#(0, -1)
     atan(x)
; atan2
     atan2(0, -1.0)
; atanh
     x = #(0, 1/2)~#(1/3, 1/4)
     atanh(x) 
; cos
     x = #(pi/2, pi/4)~#(pi, 3/4*pi)  
     cos (x)
; cosh
     x = #(1, 2)~#(3, 4)
     cosh (x)
; exp
     exp (0:1)
; expm1
     expm1 (0:1)
; fft
; invfft
     randomize(0)
     x = normal(4)
     y = #(0,0,0,0)
     z=fft(x~y)      
     invfft(z)
; fwt
     h = 1/sqrt(2).* #(1,1)
     x = (0:1023)/1023
     {a, b} = fwt (x, 4, h)
     a
; invfwt
     x = sin(6.28*(0:1023)/1023)
     {a, b} = fwt (x, 4, h)
     b[,3] = b[,3].*abs(b[,3].>0.01)
     y = invfwt(a, b, 1024, 4, h)
     t = 0:1023
     cc=createdisplay(1,1)
     show(cc, 1, 1, t~x, t~y)
; log
     log (exp((1:5)'))
; log10
     log10 (#(10, 100)')
; log1p
     log1p (expm1((1:5)'))
; sin
     x = #(pi/2, pi/4)~#(pi, 3/4*pi)  
     sin (x)
; sinh
     x = #(0, 2)~#(3, 4)
     sinh (x)
; tan
     x = #(pi/3, pi/4)~#(pi, 3/4*pi)  
     tan (x)
; tanh
     x = #(1, 2)~#(3, 4)
     tanh (x)
endp
;
proc()=matman()
"Matrix manipulation"
; []
     x=1:12
     y=reshape(x,#(3,4))
     y[2:3,1:3]
; abs
     x = #(-1, 3)~#(1, -3)
     abs(x)
; cols
     cols (matrix (10, 3))
; cummul
     x = #(1, 2, 3)~#(2, 3, 4)~#(3, 4, 5)
     cummul (x)
; cumsum
     x=#(1,2,3)~#(3,4,5)~#(5,6,7)
     cumsum (x)
; diag
     diag (1:4)
; dim
     dim (matrix(2,3,4))    
; dot
;   does not work
     x1=#(1,3)~#(3,1)
     x2=4:6
     y=list(x1,x2)
;     y.x1
; index
     x = #(0.1, 0.2, 0.3, 0.4)
     i = #(4, 3, 2, 2, 1)
     ( index (x, i) )'
; matrix
     matrix(2,5)
; mknn
     x=1:4
     y=2:5
     mknn(x,3,y)
; ncomp
     x1=(1:4)'
     x2=matrix(2,2)
     y=list(x1,x2,(4:6)')
     ncomp(y)
; paf
     randomize(0)
     x=uniform(10)
     paf(x, x>0.5)
; prod
     x = #(1, 2)~#(3, 4)~#(5, 6)
     prod (x,2)
; reshape
     x=1:20
     reshape(x,#(2,5,2))
; rows
     rows (matrix (10, 2))
; sort
     x  = #(3, 1, 1, 3, 1)~#(4, 5, 4, 2, 4)~#(1, 5, 4, 0, 1)
     sort (x', #(-1, 2))
; sqrt
     sqrt (#(9, 25, 36)')
; sum
     x = #(1, 2)~#(3, 4)~#(5, 6)
     sum (x,2)
; vec 
     vec(2,matrix(2,2),8)
; {}
     x1=#(1,3)~#(3,1)
     x2=4:6
     y=list(x1,x2)
     y{1}
endp
;
proc()=optim()
"Optimizer"
; bfgs
     x0=#(1,1,1)
     bfgs(x0,"f","df",50)
; nelmin
     x0    = #(1,1,1)~#(1,2,3)
     nelmin (x0, "f2", 100, 1.0e-6)
endp
;
proc()=plotman()
"Plot manipulation"
; adddata
; connect
; createdisplay
"a"
     di=createdisplay(1, 1)
     x=1:100
     y=sin(x/20)+uniform(100, 1)/10
     show(di, 1, 1, x~y)
     y=knn(y, 10)
     adddata(di, 1, 1, x~y)
;     connect(di, 1, 1, 2, 4, 3)
; deletedata
"b"
     di=createdisplay(1, 1)
     x=1:100
     y=sin(x/20)+uniform(100, 1)/10
     show(di, 1, 1, x~y, x~knn(y, 10))
     deletedata(di, 1, 1, 2)
; setfractions
"c"
     di=createdisplay(2, 1)
     x=1:100
     y=sin(x/20)+uniform(100, 1)/10
     setfractions(di, 5 | 1, 1)
     show(di, 2, 1, "y=sin(x/20)+uniform(100, 1)/10")
     show(di, 1, 1, x~y)         
; setheadline
"d"
     di=createdisplay(1, 1)
     x=1:100
     y=sin(x/20)+uniform(100, 1)/10
     show(di, 1, 1, x~y)
     setheadline(di, 1, 1, "A test")
; setmaskl
; setmaskp
"e"
     di=createdisplay(1, 1)
     x=1:100
     y=sin(x/20)+uniform(100, 1)/5
     data=x~y
     part=#(1, 1, 1, 1, 4)
     i=1
     while (i<20)
     part=part| (#(1, 1, 1, 1, 4))
     i=i+1
     endo
     setmaskp(data, part, 3, 8)
     fiveth=5*(1:20)
     tenth=10*(1:10) | (matrix(10)-1)
     setmaskl(data, (fiveth ~tenth)', #(4, 1), 1, #(2, 4))
     show(di, 1, 1, data)
; setxaxis
"f"
     di=createdisplay(1, 1)
     x=1:100
     y=sin(x/20)+uniform(100, 1)/10
     show(di, 1, 1, x~y)
     setxaxis(di, 1, 1, 0, 101, 0, 20, 5, 0, 1)
; setyaxis
; show
"g"
     di=createdisplay(1, 1)
     x=1:100
     y=sin(x/20)+uniform(100, 1)/10
     show(di, 1, 1, x~y)
     setyaxis(di, 1, 1, -1.5, 1.5, 0, 0.5, 0.1, 0, 1)
endp
;
proc()=precon()
"Precision Control"
; ceil
     x = #(0.79, 2.1) ~ #(-3.99, -6.01)
     ceil (x)
; floor
     x = #(0.79, 2.1) ~ #(-3.99, -6.01)
     floor (x)
endp
;
proc()=random()
"Random Variables"
; genar
     randomize(0)
     x = normal(5)
     startval = 0
     alpha = 0.1             
     genar(x, startval, alpha) 
; normal
; randomize
     randomize (0)    
     normal (2, 3)
; uniform
     randomize(0)    
     uniform (2, 3)
endp
;
proc()=readwri()
"Reading and Writing"
; func
     func("examples/switch.xpl")
; read
; write
     write(reshape(1:15,#(3,5)),"my_data.dat")
     read("my_data.dat")
; savemac
     savemac("factorial1")
endp
;
proc()=statan()
"Statistical Data Analysis"
; max
     randomize (0)
     x = normal (2, 4)
     max (x,2)
; maxind
     maxind(#(1,3)~#(4,-1))
; mean
     randomize (0)
     x = uniform (2, 4)
     mean (x,2)
; min
     randomize (0)
     x = normal (2, 4)
     min (x,2)
; minind
     minind(#(1,3)~#(4,-1))
; var
     randomize(0)
     x = normal(2, 4)
     var(x,2)
endp
;
proc()=statdis()
"Statistical Distributions"
; cdfb
     cdfb (0.5, 1.0, 1.0 )
; cdfc
     cdfc(12.59, 6)
; cdff
     cdff (5.41,3, 5 )
; cdfn
     cdfn (1.96)
; cdft
     cdft (2.92, 16)
; erf
     x = #(0, 1/sqrt(2))~#(-1, -1/sqrt(2))
     erf (x)
; erfc
     x = #(0, 1/sqrt(2))~#(-1, -1/sqrt(2))
     erfc (x)
; pdfb
     pdfb (0.5, 1.0,  1.0)
; pdfc
     pdfc (12.591, 6)
; pdff
     pdff (5.41, 3, 5)
; pdfn
     pdfn (1.96)
; pdft 
     pdft (2.92, 16 )
; qfc
     qfc (0.95,6)
; qff
     qff (0.95, 3, 5)
; qfn
     qfn (#(0.5987, 1.2)')
; qft
     qft (0.995, 16)
endp
;
proc()=time()
"Time and Date functions"
; dayofmonth
     yr = 1970 + (1:10)
     t  = settime(yr)
     ts = dayofmonth(t)
     ts
; dayofweek
     yr = 1970 + (1:10)
     t  = settime(yr)
     ts = dayofweek(t)
     ts
; hour
     yr = 1970 + (1:10)
     t  = settime(yr)
     ts = hour(t)
     ts
; minute
     yr = 1970 + (1:10)
     t  = settime(yr)
     ts = minute(t)
     ts
; month
     yr = 1970 + (1:10)
     t  = settime(yr)
     ts = month(t)
     ts
; ndayofmonth
     yr = 1970 + (1:10)
     t  = settime(yr)
     ts = ndayofmonth(t)
     ts
; ndayofweek
     yr = 1970 + (1:10)
     t  = settime(yr)
     ts = ndayofweek(t)
     ts
; nhour
     yr = 1970 + (1:10)
     t  = settime(yr)
     ts = nhour(t)
     ts
; nminute
     yr = 1970 + (1:10)
     t  = settime(yr)
     ts = nminute(t)
     ts
; nmonth
     yr = 1970 + (1:10)
     t  = settime(yr)
     ts = nmonth(t)
     ts
; nsecond
     yr = 1970 + (1:10)
     t  = settime(yr)
     ts = nsecond(t)
     ts
; nyear
     yr = 1970 + (1:10)
     t  = settime(yr)
     ts = nminute(t)
     ts
; second
     yr = 1970 + (1:10)
     t  = settime(yr)
     ts = second(t)
     ts
; settime
     yr = 1970 + (1:10)
     t  = settime (yr)
; settimegran
     yr = 1970 + (1:10)
     t  = settime (yr)
     settimegran (t, 4)
; settimezero
     yr = 1970 + (1:10)
     t  = settime (yr)
     settimezero (t, 0)
; year
     yr = 1970 + (1:10)
     t  = settime(yr)
     ts = year(t)
     ts
endp
;
proc()=vertestn()
  selhead = "Version test"
  selitem = "Nonpara"|"Bingridse"|"Flowcont"|"Guifunc"|"Infocon"|"Linalg"|"Mathfun"|"Matman"|"Optim"|"Plotman"|"Precon"|"Random"|"Readwri"|"Statan"|"Statdis"|"Time"|"All"
  end = 0
  do
    sel = selectitem(selhead, selitem)
    if (sel[1])
      nonpara()
    endif
    if (sel[2])
      bingridse()
    endif
    if (sel[3])
      flowcont()
    endif
    if (sel[4])
      guifunc()
    endif
    if (sel[5])
      infocon()
    endif
    if (sel[6])
      linalg()
    endif
    if (sel[7])
      mathfun()
    endif
    if (sel[8])
      matman()
    endif
    if (sel[9])
      optim()
    endif
    if (sel[10])
      plotman()
    endif
    if (sel[11])
      precon()
    endif
    if (sel[12])
      random()
    endif
    if (sel[13])
      readwri()
    endif
    if (sel[14])
      statan()
    endif
    if (sel[15])
      statdis()
    endif
    if (sel[16])
      time()
    endif
    if (sel[17])
      nonpara()
      bingridse()
      flowcont()
      guifunc()
      infocon()
      linalg()
      mathfun()
      matman()
      optim()
      plotman()
      precon()
      random()
      readwri()
      statan()
      statdis()
      time()
    endif
    end = (sum(sel).=0)
  until (end)
  error (1, "Version test finished")
endp
; 
vertestn()
