proc()=waveint2b(disp, col, a, b, x, dl, bo)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     waveint1b waveint3b waveint4b waveint5b
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        waveint2b
; -----------------------------------------------------------------------
; Description  Shows the mother wavelet for a given basis.
;              In the picture of the first row the function is shown. 
;              Below, in the second row, the coeffients are drawn as 
;              circles in one line for each level. The absolute size is 
;              indicated by the radius of the circle. If the circle is
;              red the coefficient is used in the approximation, 
;              otherwise the circle is blue.
; -----------------------------------------------------------------------
; Usage        waveint2b(disp, col, a, b, x, dl, bo)
; Input
;   Parameter  disp 
;   Definition display
;   Parameter  col
;   Definition scalar		which column of disp is used
;   Parameter  a
;   Definition n x 2    	father wavelet coefficients 
;   Parameter  b
;   Definition m x 3 		mother wavelet coefficients
;   Parameter  x
;   Definition (n+m) x 1	data
;   Parameter  dl
;   Definition scalar           0 function will be drawn as points
;				1 function will be drawn as line
;   Parameter  bo
;   Definition m x 3            mother wavelet coefficients (b might be
;                               thresholded)
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960916
; -----------------------------------------------------------------------
  m = 14.99
; max coeff
  mb  = max(abs(bo[,3]))
; dataset for the b's
  bx = ((0.5+b[,2])./2^b[,1])~b[,1]
  if (mb<1.0e-10)
    sb = 1+m.*abs(bo[,3])./1.0e-10
  else
    sb = 1+m.*abs(bo[,3])./mb
  endif
  sb = floor(sb)
  cb = abs(b[,3]).>1.0e-10
  cb = 1+3.*cb
; dataset for the x
  xn = rows(x)
  xx = (((1:xn)-0.5)./xn)~x
  if (dl)
    setmaskp(xx, 0, 0, 0)
    setmaskl (xx,  (1:rows(xx))', 0, 1, 3)
  endif 
; build coeff
  setmaskp (bx, cb, 3, sb)
  show (disp, 1, col, xx)
  show (disp, 2, col, bx)  
  setxaxis (disp, 1, col, -0.05, 1.05, 0, 0.2, 0.1, 0, 1)
  setxaxis (disp, 2, col, -0.05, 1.05, 0, 0.2, 0.1, 0, 1)
  setyaxis (disp, 2, col, min(b[,1])-1, max(b[,1])+1, 0, 1, 0.5, 0, 1)
endp
