proc()=waveint3b(disp, col, a, b, x, dl)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     waveint1b waveint2b waveint4b waveint5b
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        waveint3b
; -----------------------------------------------------------------------
; Description  Shows the mother wavelet for a given basis.
;              In the picture of the first row the function is shown. 
;              Below, in the second row, the coeffients are drawn as 
;              vertical lines. All coefficients are ordered by absolute
;              size. Just one quarter of all coefficients is drawn.
; -----------------------------------------------------------------------
; Usage        waveint3b(disp, col, a, b, x, dl)
; Input
;   Parameter  disp 
;   Definition display
;   Parameter  col
;   Definition scalar		which column of disp is used
;   Parameter  a
;   Definition n x 2    	father wavelet coefficients 
;   Parameter  b
;   Definition m x 3 		mother wavelet coefficients
;   Parameter  x
;   Definition (n+m) x 1	data
;   Parameter  dl
;   Definition scalar           0 function will be drawn as points
;				1 function will be drawn as line
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960916
; -----------------------------------------------------------------------
; max coeff
  m  = sort(abs(a[,2])|abs(b[,3]), -1)
  mm = m[4]
; dataset for the b's
  if (mm<1.0e-10)
    bx  =  m[4:(rows(b)+rows(a))/4]./1.0e-10
  else
    bx  =  m[4:(rows(b)+rows(a))/4]./mm
  endif
  cb  =  ((1:rows(bx))~bx)|((1:rows(bx))~(0.*matrix(rows(bx))))
  sb = (1:rows(bx))~((rows(bx)+1):(2*rows(bx)))
; dataset for the x
  xn = rows(x)
  xx = (((1:xn)-0.5)./xn)~x
  if (dl)
    setmaskp(xx, 0, 0, 0)
    setmaskl (xx,  (1:rows(xx))', 0, 1, 3)
  endif 
; build coeff
  setmaskp (cb, 0, 0, 0)
  setmaskl (cb, sb, 0, 1, 3)
  show (disp, 1, col, xx)
  show (disp, 2, col, cb)  
  setxaxis (disp, 1, col, -0.05, 1.05, 0, 0.2, 0.1, 0, 1)
endp
