proc (d) = xdiagp (x,w)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      xdiag diag
; -----------------------------------------------------------------
;   Keywords     matrix manipulation, matrix, projection matrix
; -----------------------------------------------------------------
;   Macro        xdiagp
; -----------------------------------------------------------------
;   Description  Calculates the diagonal elements of a 
;                projection matrix.
; -----------------------------------------------------------------
;   Usage        d = xdiagp (x)
;   Input
;     Parameter    x
;     Definition   n x p matrix
;   Input
;     Parameter    w
;     Definition   optional, scalar or n x 1 weight vector
;   Output
;     Parameter  d
;     Definition   n x 1 vector of diagonal elements of 
;                  X(X'WX)^(-1) X' or W'^(1/2)X(X'WX)^(-1) X'W^(1/2)
; -----------------------------------------------------------------
;   Example   library("xplore")
;             n=10
;             x=(1:n)~matrix(n)
;             xdiagp(x)
; -----------------------------------------------------------------
;   Result
;             Contents of d
;             [ 1,]  0.34545 
;             [ 2,]  0.24848 
;             [ 3,]  0.17576 
;             [ 4,]  0.12727 
;             [ 5,]  0.10303 
;             [ 6,]  0.10303 
;             [ 7,]  0.12727 
;             [ 8,]  0.17576 
;             [ 9,]  0.24848 
;             [10,]  0.34545  
; -----------------------------------------------------------------
;   Author    TTK, 961127; Marlene Mueller, 970930
; -----------------------------------------------------------------
  {e,v}=eigsm(x'*x)
  d=(x*v).*(sqrt(1/e)')
  if (exist(w))  
    d =sqrt(w).*d  
  endif  
  d=sum(d.*d,2)
endp


