proc(yh)=xgobiknn(x,y,g,kp)
; -----------------------------------------------------------------------
; Library      rpclib
; -----------------------------------------------------------------------
; See_also     xgobiisotonic xgobilinreg xgobisknn
; -----------------------------------------------------------------------
; Macro        xgobiknn
; -----------------------------------------------------------------------
; Description  conmputes an k-nn fit for XGobi
; -----------------------------------------------------------------------
; Usage        yh = xgobiknn(x,y,g,h)
; Input
;   Parameter  x
;   Definition n x 1    matrix
;   Parameter  y
;   Definition n x 1    matrix
;   Parameter  g
;   Definition n x 1    matrix with integers starting at zero
;   Parameter  kp
;   Definition scalar   number of neighbours
; Output
;   Parameter  yh
;   Definition n x 1    matrix smoothed fit
; -----------------------------------------------------------------------
; Notes        XGobi gives kp as negative number which allows the user
;	       to use the macro for other purposes. We expect that XGobi
;              sets kp between -333 and -3900.
; -----------------------------------------------------------------------
; Example      ; load the library for XGobi
;	       library ("rpclib")
;              ; create a display
;	       d=createdisplay(1,1)
;	       ; read a data set
;  	       x=read("motcyc")
;              ; generate randomly three subgroups
;  	       g=floor(3.*uniform(rows(x)))
;              ; color the data after the subgroups
;              setmaskp (x, g, 3, 4)
;              ; show the data and the smooth
;              show (d, 1, 1, x, x[,1]~xgobiknn(x[,1],x[,2],g,7))
; -----------------------------------------------------------------------
; Result       shows a k-nn fit for the three different subgroups
;	       in the data
; -----------------------------------------------------------------------
; Link         http://www.public.iastate.edu/~dicook/research/software.html XGobi
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960709
; -----------------------------------------------------------------------
  if (kp<0)
    kp = abs(kp)/4000
    string ("neighbours : %.3f", kp) 
  endif
  i  = 0
  mg = 1+max(g)
  yh = y
  k  = 1:rows(x)
  while (i<mg)
    xg = paf(x, g.=i)
    yg = paf(y, g.=i)
    kg = paf(k, g.=i)
    xg = sort(xg~yg~kg)
    yg = xg[,2]
    kg = xg[,3]
    xg = xg[,1]
    kpp = 1+ceil(kp.*(rows(xg)-2)) 
    ind = mknn(xg, kpp)
    ye  = 0.*matrix(rows(xg))
    j   = 0
    while (j.<cols(ind))
      j    = j+1
      indi = ind[,j]
      ye   = ye+index(yg, indi)
    endo
    yh[kg] = ye./cols(ind)
    i = i+1
  endo
endp
