proc(z)=zxgen(serie,beginn,ende,order,meanadj)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  ymulz, zmulz
; ----------------------------------------------------------------------
;   Macro	  zxgen
; ----------------------------------------------------------------------
;   Description   concatenates a VAR series
; ----------------------------------------------------------------------
;   Usage         z = zxgen(serie,beginn,ende,order,meanadj)
;   Input 
;     Parameter   serie 
;     Definition    N x K matrix
;     Parameter   beginn  
;     Definition    integer, >= order
;     Parameter   ende 
;     Definition    integer, >= beginn
;     Parameter   order 
;     Definition    integer 
;     Parameter   meanadj 
;     Definition    scalar, 1=is mean adjusted, 0=is not
;   Output
;     Parameter   z
;     Definition    matrix, dimension depends on meanadj
; ----------------------------------------------------------------------
;   Example       library("multi")
;                 zxgen(1:3~2:4~3:5,2,3,2,1)
; ----------------------------------------------------------------------
;   Result        Contents of z 
;                 [1,]        2        3 
;                 [2,]        3        4 
;                 [3,]        4        5 
;                 [4,]        1        2 
;                 [5,]        2        3 
;                 [6,]        3        4 
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Sperlich 971024
; ----------------------------------------------------------------------
z=ones(1,ende-beginn+1)
i=0
while (i<order) 
   z=z|serie[,beginn-i:ende-i]
   i=i+1
endo
if (meanadj==1)
   if (order==0)
   z=0
   else
     z=z[2:rows(z),]
   endif
endif
endp
 
