%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulation Nr. 1  
%         
%         Funktion:
%         Hauptprogramm
%
%	  author:  Peter Wellig, Martin Haenggi, Markus Hofbauer
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  s1_calc.m
%
%
% Startfile:  sim1.m
%
% Hauptfile:  s1_calc.m
% (wird aufgerufen)
%
% Benoetigte m-Files: im Verzeichnis sim1
%
%-------------------------------------------------------------------
%===================================================================




%===================================================================
% Vorbereitungen
%===================================================================

pause(0);                                 
set(htmess,'String',message_sim_lau_vor);  % message 
        
    % Hinweis: pause(0) wird jeweils eingesetzt, damit der 
    % nachfolgende Befehl augenblicklich ausgefuehrt wird
    					   
%-------------------------------------------------------------------
% Lesen der Eingabeparameter
%------------------------------------------------------------------- 

p1=(get(h1,'value'));
f_s=p1;                         % Abtastfrequenz [Hz];     

%------------------------------------------------------------------- 
%  Initialisierungen und Definitionen
%------------------------------------------------------------------- 

% flags
busy_flag=1;
pause_flag=1;
termin_flag=0; 
error_flag=0;
stop_flag=0;

clear Jw Jv J             
Jmin=1;			% analytisch berechneter minimaler MSE 
sd2=1.5;		% sd2=E{d^2[k]} Varianz von d

f_o=50;                 % Netzfrequenz   [Hz]
f_n=f_o/f_s;            % normierte Frequenz   [Hz]


%===================================================================
% Berechnungen
%===================================================================

%------------------------------------------------------------------- 
% Wienerloesung  w0=[w1; w2]
%------------------------------------------------------------------- 

a=1; b= cos(2*pi*f_n);     
c=cos(2*pi*f_n+pi/3);

R=0.5*[a b ; b a];  	% Autokorrelationsmatrix
p=0.5*[cos(pi/3);c];	% Kreuzkorrelationsvektor p
                      
w0=inv(R)*p;		% Wiener-Hopf Gleichung 


if stop_flag==1  stop_b ; return ; end      % stop ?

%------------------------------------------------------------------- 
% Eigenwerte und normierte Eigenvektoren von R
%------------------------------------------------------------------- 
	
[Q,D]=eig(R);	% Q:  Modalmatrix (Eigenvektoren als Spalten)
eig1=D(1,1);	% eig1: 1. Eigenwert
eig2=D(2,2);	% eig2: 2. Eigenwert

%------------------------------------------------------------------- 
% Fehlerflaeche  Jw in w-Koordinaten
%------------------------------------------------------------------- 

Nr_points=31;	        % Wahl eines (31x31) Punkte Netzes 
x=-4:8/(Nr_points-1):4; % aequidistante Punkte im Bereich (-4..4 x -4..4)
y=-4:8/(Nr_points-1):4;

for kx=1:Nr_points                  % Berechnung der Fehlerflaeche ueber 
  for ky=1:Nr_points                % (31x31) Punkte Netz von w 
     w=[x(kx); y(ky)];   	    
     Jw(ky,kx)=sd2-2*p'*w+w'*R*w;   % Jw in w-Koordinaten
  end;
end;

%------------------------------------------------------------------- 
% Fehlerflaeche  Jv in v-Koordinaten
%------------------------------------------------------------------- 

for kx=1:Nr_points              % Berechnung der Fehlerflaeche ueber
  for ky=1:Nr_points            % (31x31) Punkte Netz von v 
    v=[x(kx); y(ky)]; 		
    Jv(ky,kx)=Jmin+v'*R*v;	% Jv in v-Koordinaten
   end;
end;

%------------------------------------------------------------------- 
% Fehlerflaeche  J in v'-Koordinaten (Hauptachsensystem)
%------------------------------------------------------------------- 

for kx=1:Nr_points                %Berechnung der Fehlerflaeche ueber
  for ky=1:Nr_points              % (31x31) Punkte Netz von v'
    v1=x(kx); v2=y(ky);	
    J(ky,kx)=Jmin+v1^2*eig1+v2^2*eig2;	% J in v'-Koordinaten
  end;
end;

%===================================================================
% Graphik
%===================================================================

pause(0);  
set(htmess,'String',message_sim_lau_gra);   % message
if stop_flag==1  stop_b ; return ; end      % stop ?

%------------------------------------------------------------------- 
% figur(2) 2D und 3D Darstellung von Jw in w-Koordinaten
%------------------------------------------------------------------- 

f2=figure(2); clf; 
if first_time set(f2,'Position',[8 490 410 450]); end;

% 3D-Darstellung
subplot(211);
  mesh(x,y,Jw);	 view(18.5,22) ;	    
  title('Fehlerflaeche, w-System');
  %xlabel('w_1'); 
  ylabel('w_2'); 

% 2D, Hoehenlinien bei 1.05,2,3,...,10
set(subplot(212),'Position',[0.3 0.1 0.4 0.4]);
  contour(x,y,Jw,[1.05 2:10]); 
  grid;
  title('Hoehenlinien, w-System');
  xlabel('w_1');
  ylabel('w_2');


%------------------------------------------------------------------- 
% figur(3) 2D und 3D Darstellung von Jv in v-Koordinaten (v=w-w0)
%------------------------------------------------------------------- 

f3=figure(3); clf; 
if first_time set(f3,'Position',[428 490 409 450]); end

% 3D-Darstellung
subplot(211);
  mesh(x,y,Jv); view(18.5,22) ;
  title('Fehlerflaeche , v-System');
  %xlabel('v_1');
  ylabel('v_2');

% 2D, Hoehenlinien bei 1.05,2,3,...,10
set(subplot(212),'Position',[0.3 0.1 0.4 0.4]);
  contour(x,y,Jv,[1.05 2:10]);
  grid;
  title('Hoehenlinien, v-System');
  xlabel('v_1'); ylabel('v_2');

%------------------------------------------------------------------- 
% figur(3) 2D und 3D Darstellung von J in v'-Koordinaten 
%------------------------------------------------------------------- 

f4=figure(4); clf; 
if first_time set(f4,'Position',[849 490 408 450]); end

%3D-Darstellung
subplot(211);
  mesh(x,y,J); view(18.5,22) ;
  title('Fehlerflaeche, v''-System  (Hauptachsen)');
  %xlabel('v_1'''); 
  ylabel('v_2''');

% 2D, Hoehenlinien bei 1.05,2,3,...,10
set(subplot(212),'Position',[0.3 0.1 0.4 0.4]);
  contour(x,y,J,[1.05 2:10]);
  grid;
  title('Hoehenlinien, v''-System (Hauptachsen)');
  xlabel('v_1'''); ylabel('v_2''');

if stop_flag==1  stop_b ; return ; end      % stop ?

%------------------------------------------------------------------- 
% figur(5) Schnittparabeln laengs der Hauptachsen
%-------------------------------------------------------------------      

mid=round(0.5*(Nr_points+1));   % Mitte des Netzes
axis1=J(mid,:);		        % Querschnitt von J laengs der 1. Hauptachse
axis2=J(:,mid);		        % 2. Hauptachse

f5=figure(5); clf; 
if first_time set(f5,'Position',[429 7 409 397]); end;

plot(x,axis1,y,axis2);
  grid;
  title('Schnittparabeln laengs der Hauptachsen');
  xlabel('v_1'', v_2'''); ylabel('J');

if stop_flag==1  stop_b ; return ; end      % stop ?
  
%-------------------------------------------------------------------   
% nummerische Berechnung von Jw_min und der 2. Ableitung der Parabeln
%------------------------------------------------------------------- 

% nummerische Berechnung des Minimums von Jw 
Jw_min=min(min(Jw));		

% nummerische Berechnung der 2. Ableitung
delta=8/(Nr_points-1);
d1=diff(axis1)/delta;	% d1 : 1. Ableitung Achse 1
dd1=diff(d1)/delta;	% dd1: 2. Ableitung Achse 1
d2=diff(axis2)/delta;	% d2 : 1. Ableitung Achse 2
dd2=diff(d2)/delta;	% dd2: 2. Ableitung Achse 2

% Konditionszahl von R

cond_nr=cond(R);

%===================================================================
% I/0 Fenster, Ausgabe 
%===================================================================



set(hta1,'String',['=  [',num2str(w0'),']^t']);
set(hta2,'String',['=  ',num2str(eig2),'  /  ',num2str(eig1)]);
set(hta3,'String',['=  ',num2str(Jw_min)]);
set(hta4,'String', ['=  ',num2str(0.5*dd2(1))]);
set(hta5,'String',['=  ',num2str(0.5*dd1(1))]);
set(hta6,'String',['=  ',num2str(cond_nr)] );
set(hta7b,'String',['=  ',num2str(f_o/f_s)] );
set(hta7,'String',['=  ',num2str(f_o),'  /  ',num2str(f_s)]);
set(hta8,'String',[num2str(2*f_n),' \pi']);

set(htmess,'String',message_sim_abg); 


%-------------------------------------------------------------------
% Abschluss
%-------------------------------------------------------------------

busy_flag=0;
first_time=0;


if termin_flag==1; terminate; end


%============================== end ================================




