%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulation Nr. 1  
%         
%         Funktion:
%         Einrichten des gui Ein- und Ausgabefensters
%         und Aufruf des Hauptprogramms
%
%	  author:  Markus Hofbauer,
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  sim1.m
%
%
% Startfile:  sim1.m
%
% Hauptfile:  s1_calc.m
% (wird aufgerufen)
%
% Benoetigte m-Files: im Verzeichnis sim1
%
%-------------------------------------------------------------------
%===================================================================




%===================================================================
% Initialisierung und Definitionen
%===================================================================

% close/clear all

figure(1); close 1;
close all; clear;


% Definition globaler Variablen

global stop_flag
stop_flag=0;
global busy_flag
busy_flag=0;
global termin_flag
termin_flag=0;
global pause_flag;
pause_flag=1;
global contin_flag;
contin_flag=0;

first_time=1;

%-------------------------------------------------------------------
% Koordinatendefinitionen des IO-Fensters
%-------------------------------------------------------------------

% IO-Fenster

wb=350; wh=450;           %   Breite, Hoehe
iowinpos=[10 10 wb wh];   %   Position

% Eingabefelder

fb=60;                        % Feldbreite
fh=20;                        % Feldhoehe 
fa=30;                        % Feldabstand vertikal
sp1=20; sp2=160 ; sp3=wb-80;  % 1,2,3. Spalte
re1=wh-80; re2= 0.55*wh;      % 1. und 2. Zeile (Eingabe und Ausgabe)
kor=5;                        % Korrektur 

%-------------------------------------------------------------------
% I/O Figur Initialisierung
%-------------------------------------------------------------------

f_IO=figure('resize','off','numbertitle','off','name','I/0','Position',iowinpos); 
ha=axes ; axis off;
set(ha,'position',[0 0 1 1],'xlim',[0 wb],'ylim',[0 wh]);
fontsi=get(ha,'fontsize');
patch([0 wb wb 0 0],[0 0 re2  re2 0],[0.75 0.75 0.75])
patch([0 wb wb 0 0],[re2+50 re2+50  re1 re1 re2+50],[0.75 0.75 0.75])


%===================================================================
%  Definition der Ein- und Ausgabeparameter
%===================================================================

% aufgerufenes Hauptprogramm
callfile='s1_calc';        % wird von start aufgerufen 

%-------------------------------------------------------------------
%  Eingabeparameter
%-------------------------------------------------------------------


slidinit=500 ;                              % Initwert Slider


%-------------------------------------------------------------------
% Ausgabeparameter
%-------------------------------------------------------------------

pa1str='w_0  ';  
pa1init='' ;

pa2str='\lambda_{max} / \lambda_{min}';  
pa2init=''  ;

pa3str='J_{min}';  
pa3init=''  ;

pa4str='0.5 \cdot ( \partial^2J / \partialv_1^{2}'' )';  
pa4init=''  ;

pa5str='0.5 \cdot ( \partial^2J / \partialv_2^{2}'' )';  
pa5init=''  ;

pa6str='\chi({\bfR}) = \lambda_{max} / \lambda_{min}';  
pa6init=''  ;

pa7str='f_n = f_o / f_s';  
pa7init=''  ;

pa8str='Phase zwischen x[k] und x[k-1]:    2\pi f_n = ';  
pa8init=''  ;

%-------------------------------------------------------------------
% messages
%-------------------------------------------------------------------

message_init='';
message_sim_lau='Simulation laeuft : ';
message_sim_lau_vor='Simulation laeuft : Vorbereitung';
message_sim_lau_ausw='Simulation laeuft : Auswertung';
message_sim_lau_gra='Simulation laeuft : Graphik';
message_sim_stop='Simulation gestoppt';
message_sim_wstop='Simulation wird gestoppt';
message_sim_abg='Simulation abgeschlossen';
message_sim_start='Simulation laeuft bereits';


%===================================================================
% gui mit den definierten Ein- und Ausgabeparametern
%===================================================================

%-------------------------------------------------------------------
% buttons
%-------------------------------------------------------------------

% Start
hstart=uicontrol(f_IO,'Style','pushbutton','Position',[wb-210 re1+40 100 ...
      23],'String','Start','CallBack','start','ForegroundColor',[1 1 0] );   

% Ende
hterm=uicontrol(f_IO,'Style','pushbutton','Position',[wb-105 re1+15 100 ...
      23],'String','Ende','CallBack','terminate','ForegroundColor',[1 1 ...
      0] );  

% Stop
hstop=uicontrol(f_IO,'Style','pushbutton','Position',[wb-105 re1+40 100 ...
      23],'String','Stop','CallBack','stop_a','ForegroundColor',[1 1  0]);  


%-------------------------------------------------------------------
% Eingabe
%-------------------------------------------------------------------

% Eingabe
uicontrol(f_IO,'Style','text','Position',[sp1 re1+40 100 ...
       23],'string','Eingabe:','foregroundColor',[1 1 0],'FontSize',1.5*fontsi);
 
% Slider
h1=uicontrol(f_IO,'Style','slider','min',200,'max',2000,'value',slidinit,'Position',[20 re1-1*fa wb-40 15],'Callback','setslidval','ForegroundColor',[1 1 0]);
 text(20,re1-fa-fh,num2str(get(h1,'min')));
 text(wb-40,re1-fa-fh,num2str(get(h1,'max')));
 hslval=text('Position',[wb/2-25 re1-1*fa-fh-kor]);
 set(hslval,'String',['f_s = ',num2str(slidinit)]);

%-------------------------------------------------------------------  
% Ausgabefelder
%-------------------------------------------------------------------

% Ausgabe  
uicontrol(f_IO,'Style','text','Position',[sp1 re2+10 100 ...
      23],'string','Ausgabe:','ForegroundColor',[1 0 0],'FontSize',1.5*fontsi);

% message
htmess=text('Position',[sp2 re2+15]);
set(htmess,'String',message_init);

% parameter 1
text(sp1,re2-1*fa+fh/2-kor,pa1str);
  hta1=text('Position',[sp2 re2-1*fa+fh/2]);

% parameter 2
text(sp1,re2-3*fa+fh/3-kor,pa2str);
  hta2=text('Position',[sp2 re2-3*fa+fh/2]);

% parameter 3
text(sp1,re2-2*fa+fh/2-kor,pa3str);
  hta3=text('Position',[sp2 re2-2*fa+fh/2]);

% parameter 4
text(sp1,re2-4*fa+fh/2-kor,pa4str);
  hta4=text('Position',[sp2 re2-4*fa+fh/2]);

% parameter 5
text(sp1,re2-5*fa+fh/2-kor,pa5str);
  hta5=text('Position',[sp2 re2-5*fa+fh/2]);

% parameter 6
text(sp1,re2-6*fa+fh/2-kor,pa6str);
  hta6=text('Position',[sp2 re2-6*fa+fh/2]);

% parameter 7
text(sp1,re2-7*fa+fh/2-kor,pa7str);
  hta7=text('Position',[sp2 re2-7*fa+fh/2]);
  hta7b=text('Position',[sp3 re2-7*fa+fh/2]);
% parameter 8
text(sp1,re2-8*fa+fh/2-kor,pa8str);
  hta8=text('Position',[sp3 re2-8*fa+fh/2]);

%-------------------------------------------------------------------
%
%-------------------------------------------------------------------

set(f_IO,'handlevisibility','off')    % verhindert versehentliches
                                      % zeichnen in I/O Fenster


%============================== end ================================