%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulation Nr. 2 
%         
%         Funktion:
%         Hauptprogramm
%
%	  author:  Markus Hofbauer
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  s2_calc.m
%
%
% Startfile:  sim2.m
%
% Hauptfile:  s2_calc.m
% (wird aufgerufen)
%
% Benoetigte m-Files: im Verzeichnis sim2
%
%-------------------------------------------------------------------
%===================================================================




%===================================================================
% Vorbereitungen
%===================================================================

pause(0);                                 
set(htmess,'String',message_sim_lau_vor);  % message 
        
    % Hinweis: pause(0) wird jeweils eingesetzt, damit der 
    %          nachfolgende Befehl augenblicklich ausgefuehrt wird
    					   
%-------------------------------------------------------------------
% Lesen der Eingabeparameter
%------------------------------------------------------------------- 

p1=str2num(get(h1,'string'));
p2=str2num(get(h2,'string'));

N=min(p1,100);            %  Dimension NxN von R
K=min(p2,100);            %  Anzahl Schwingungen unterschiedlicher Frequenzen

set(h1,'string',num2str(N))
set(h2,'string',num2str(K))

%------------------------------------------------------------------- 
% Test auf Gueltigkeit der Eingabe
%------------------------------------------------------------------- 

if N<2 | K<1 | (N ~= ceil(N)) | (K ~= ceil(K)) 
 set(htmess,'String',message_err); error_flag=1;
else 
 error_flag=0; 
end 


if error_flag==0;             % falls gueltige Eingabe 

%------------------------------------------------------------------- 
%  Initialisierungen und Definitionen
%------------------------------------------------------------------- 

% flags
busy_flag=1;
termin_flag=0; 
stop_flag=0;

Rg=zeros(N,N);       % Matrix R fuer alle K Schwingungen
f_n=0.45*(1:K)/(K) ; % K unterschiedliche Frequenzen 
                     %(f_n=f/fs normierte Frequenz)
                     % f=(1/K,2/K,...,1)*0.45*fs   Abtasttheorem: f < 0.5 f_s
r=zeros(N,1);        % AKF        

format compact;

%===================================================================
% Bestimmung von  R der Dimension (NxN) fuer eine Summe von  K Schwingungen
%===================================================================

pause(0);
set(htmess,'String',message_sim_lau);    % message

for k=1:K  
  for n=1:N
    r(n)=akf(n-1,f_n(k));  % AKF der k-ten Frequenz
  end;
  R=toeplitz(r,r);          % R der k-ten Frequenz
  Rg=Rg+R;                  % R aller k Frequenzen (Addition erlaubt,
end;                        % weil Schwingung k orthogonal zur 
                            % Schwingung k+1 ist)

Rg=Rg/K ;                   % Normierung von R

% Rang von R
ra=rank(Rg);
% Eigenwerte von R (der Groesse nach geordnet)
eig=svd(Rg); 


%===================================================================
% Graphik
%===================================================================

pause(0);  
set(htmess,'String',message_sim_lau_gra);   % message

%-------------------------------------------------------------------
% Darstellung der N Eigenwerte 
%-------------------------------------------------------------------

f2=figure(2); clf; 

plot(eig,'ro')
  hold on ; grid
  for  n=1:rank(Rg)
    plot(n,eig(n),'o')    
  end
  axis([0 N+1 0 max(svd(Rg)+1)])
  title(['Eigenwerte \lambda {}_i' ])
  xlabel('Index i');        
  ylabel('\lambda_i');
  leg=legend('\lambda {}_i \approx 0','\lambda {}_i > 0');
  legch=get(leg,'children');
  pos=get(legch(3),'position');   
  pos(2)=0.7*pos(2);
  set(legch(3),'position',pos);
  
%===================================================================
% I/0 Fenster, Ausgabe 
%===================================================================

set(hta1,'String',num2str(ra)); 
set(htmess,'String',message_sim_abg); 

end;   % end (if error_flag==0)

%-------------------------------------------------------------------
% Abschluss
%-------------------------------------------------------------------

busy_flag=0;

if termin_flag==1; terminate; end


%============================== end ================================
