%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulation Nr. 2 
%         
%         Funktion:
%         Einrichten des gui Ein- und Ausgabefensters
%         und Aufruf des Hauptprogramms
%
%	  author:  Markus Hofbauer,
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  sim2.m
%
%
% Startfile:  sim2.m
%
% Hauptfile:  s2_calc.m
% (wird aufgerufen)
%
% Benoetigte m-Files: im Verzeichnis sim2
%
%-------------------------------------------------------------------
%===================================================================




%===================================================================
% Initialisierung und Definitionen
%===================================================================

% close/clear all

figure(1); close 1;
close all; clear;


% Definition globaler Variablen

global stop_flag
stop_flag=0;
global busy_flag
busy_flag=0;
global termin_flag
termin_flag=0;
global pause_flag;
pause_flag=1;
global contin_flag;
contin_flag=0;

first_time=1;


%-------------------------------------------------------------------
% Koordinatendefinitionen des IO-Fensters
%-------------------------------------------------------------------

% IO-Fenster

wb=350; wh=280;           %   Breite, Hoehe
iowinpos=[10 400 wb wh];   %   Position

% Eingabefelder

fb=60;                        % Feldbreite
fh=20;                        % Feldhoehe 
fa=30;                        % Feldabstand vertikal
sp1=20; sp2=130 ; sp3=200;    % 1,2,3. Spalte
re1=wh-60; re2= 0.3*wh;      % 1. und 2. Zeile (Eingabe und Ausgabe)
kor=5;                        % Korrektur 

%-------------------------------------------------------------------
% I/O Figur Initialisierung
%-------------------------------------------------------------------

f_IO=figure('resize','off','numbertitle','off','name','I/0','Position',iowinpos); 
ha=axes ; axis off;
set(ha,'position',[0 0 1 1],'xlim',[0 wb],'ylim',[0 wh]);
fontsi=get(ha,'fontsize');
patch([0 wb wb 0 0],[0 0 re2  re2 0],[0.75 0.75 0.75])
patch([0 wb wb 0 0],[re2+50 re2+50  re1 re1 re2+50],[0.75 0.75 0.75])


%===================================================================
%  Definition der Ein- und Ausgabeparameter
%===================================================================

% aufgerufenes Hauptprogramm
callfile='s2_calc';        % wird von start aufgerufen 

%-------------------------------------------------------------------
%  Eingabeparameter
%-------------------------------------------------------------------


p1str='N :';                             % label Parameter 1
p1init=10 ;                              % Initwert 
p1message=' 1 < N < 50' ;                % Zusatz label

p2str='K :';  
p2init=4   ;
p2message=' 0 < K < 50' ; 

%-------------------------------------------------------------------
% Ausgabeparameter
%-------------------------------------------------------------------

pa1str='Rang von R :';  

pa2str='# \lambda {}_i\neq 0 : ';  


%-------------------------------------------------------------------
% messages
%-------------------------------------------------------------------

message_init='';
message_err='ungeeignete Eingabe  !';
message_sim_lau='Simulation laeuft : ';
message_sim_lau_vor='Simulation laeuft : Vorbereitung';
message_sim_lau_ausw='Simulation laeuft : Auswertung';
message_sim_lau_gra='Simulation laeuft : Graphik';
message_sim_stop='Simulation gestoppt';
message_sim_wstop='Simulation wird gestoppt';
message_sim_abg='Simulation abgeschlossen';
message_sim_start='Simulation laeuft bereits';


%===================================================================
% gui mit den definierten Ein- und Ausgabeparametern
%===================================================================

%-------------------------------------------------------------------
% buttons
%-------------------------------------------------------------------

% Start
hstart=uicontrol(f_IO,'Style','pushbutton','Position',[wb-210 re1+25 100 ...
      23],'String','Start','CallBack','start','ForegroundColor',[1 1 0] );   

% Ende
hterm=uicontrol(f_IO,'Style','pushbutton','Position',[wb-105 re1+25 100 ...
      23],'String','Ende','CallBack','terminate','ForegroundColor',[1 1 ...
      0] );  

%-------------------------------------------------------------------
% Eingabefelder
%-------------------------------------------------------------------

% Eingabe
uicontrol(f_IO,'Style','text','Position',[sp1 re1+25 100 ...
       23],'string','Eingabe:','foregroundColor',[1 1 0],'FontSize',1.5*fontsi);
 
% parameter 1
h1=uicontrol(f_IO,'Style','edit','Position',[sp2  re1-1*fa fb ...
      fh],'string',num2str(p1init),'ForegroundColor',[1 1 0]);
   text(sp1,re1-1*fa+fh/2-kor,p1str);
   ht1=text('Position',[sp3 re1-1*fa+fh/2]);
   set(ht1,'String',p1message);

% parameter 2
h2=uicontrol(f_IO,'Style','edit','Position',[sp2  re1-2*fa fb ...
      fh],'string',num2str(p2init),'ForegroundColor',[1 1 0]);
   text(sp1,re1-2*fa+fh/2-kor,p2str);
   ht2=text('Position',[sp3 re1-2*fa+fh/2]);
   set(ht2,'String',p2message);

%-------------------------------------------------------------------  
% Ausgabefelder
%-------------------------------------------------------------------

% Ausgabe  
uicontrol(f_IO,'Style','text','Position',[sp1 re2+10 100 ...
      23],'string','Ausgabe:','ForegroundColor',[1 0 0],'FontSize',1.5*fontsi);

% message
htmess=text('Position',[sp2 re2+15]);
set(htmess,'String',message_init);

% parameter 1
text(sp1,re2-1*fa+fh/2,pa1str);
  hta1=text('Position',[sp2 re2-1*fa+fh/2]);
 

%% parameter 2
%text(sp1,re2-2*fa+fh/2,pa2str);
%  hta2=text('Position',[sp2 re2-2*fa+fh/2]);


  
%-------------------------------------------------------------------
%
%-------------------------------------------------------------------

set(f_IO,'handlevisibility','off')    % verhindert versehentliches
                                      % zeichnen in I/O Fenster


%============================== end ================================