%-----------------------------------------------------------------
%
%         Adaptive Filter und neuronale Netze
%         Uebung Nr.5 : LMS
%   
%         [J] = calcJ(sd2, p, R, arg1, arg2);
%
%         Berechnet die Kurve auf der Fehlerflaeche oder die 
%         Fehlerflaeche selber
%         falls nur arg1 angegeben:
%           arg1 : 2xN Matrix mit verschiedenen w-Werten
%         falls arg1 und arg2 angegeben:
%           arg1 enthaelt die w1- und arg2 enthaelt die
%           w2-Werte fuer die die Fehlerflaeche berechnet wird
%
%         Pascal Vontobel & Dieter Arnold, 27.11.1997
%
%-----------------------------------------------------------------
function [J] = calcJ(sd2, p, R, arg1, arg2);

if (nargin==4);
  w = arg1;
  J = zeros(1,size(w,2));

  for ii=1:size(w,2);
    J(ii) = sd2 - 2*p'*w(:,ii) + w(:,ii)'*R*w(:,ii);
  end;
elseif (nargin==5);
  J = zeros(length(arg2),length(arg1));
  
  for ii=1:length(arg1);
    for jj=1:length(arg2);
      w = [arg1(ii), arg2(jj)]';
      J(jj,ii) = sd2 - 2*p'*w + w'*R*w;
    end;
  end;
end;
