%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulationen  
%         
%         function [ry]=calc_ry(b,a,rx,N_stat);
%
%         Berechnung der Autokorrelationsfunktion ry des Ausgangs
%         eines Filters
%
%              x: Eingang, y: Ausgang des Filters mit den
%              Koeffizienten b,a

%              ry: Autokorrelationsfunktion y
%              rx: Autokorrelationsfunktion x
%              N_stat: Faltungslaenge. Je laenger rx oder 
%              die Systemstossantwort, desto groesser muss N_stat 
%              sein, um eine gleiche Genauigkeit zu erreichen.
%
%              Berechnung: ry[.] = h[.] * h[-.] * rx
%                          h: Systemstossantwort
%
%-------------------------------------------------------------------

%
%	  author:  Markus Hofbauer,
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  calc_ry.m
%
% Startfile:  simX.m
%
%-------------------------------------------------------------------
%===================================================================


function [ry]=calc_ry(b,a,rx,N_stat);

N_stat= 2^ceil(log2(N_stat)); 
Nl=N_stat/2;

% Autokorrelationsfunktion von x 
rx=[rx zeros(1,N_stat-lge(rx))];  % einseitig
rx=[rx(lge(rx):-1:2) rx];         % zweiseitige Ergaenzung

% Systemstossantwort
dir=zeros(1,N_stat); dir(1)=1;    % dirac-Puls
h=filter(b,a,dir);                % Systemstossantwort h[.]
clear hr; 
hr(lge(h):-1:1)=h;                % Zeitumkehrung h[.-]
hrs=hr(N_stat-Nl+1:N_stat);

h_hm=filter(hrs,1,h);             % h_hm[.] = h[.] * h[-.]

% Autokorrelationsfunktion von y  
ry1=filter(h_hm,1,rx);            % ry[.] = h_hm[.] * rx[.]
ry=(ry1(Nl+N_stat-1:lge(ry1)));   % Nullpunkt bei ry[1]
 
 
