%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulationen  
%         
%         function [ryx]=calc_ryx(b,a,rx,N_stat);
%
%         Berechnung der Kreuzkorrelationsfunktion ryx
%
%              x: Eingang, y: Ausgang des Filters mit den
%              Koeffizienten b,a

%              ryx:Kreuzkorrelationsfunktion
%              rx: Autokorrelationsfunktion
%              N_stat: Faltungslaenge. Je laenger rx oder 
%              die Systemstossantwort, desto groesser muss N_stat 
%              sein, um eine gleiche Genauigkeit zu erreichen.
%
%              Berechnung: ryx[.] = h[.] * rx
%                          h: Systemstossantwort
%
%-------------------------------------------------------------------

%
%	  author:  Markus Hofbauer,
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  calc_ryx.m
%
% Startfile:  simX.m
%
%-------------------------------------------------------------------
%===================================================================



function [ryx]=calc_ryx(b,a,rx,N_stat);

N_stat= 2^ceil(log2(N_stat)); 
Nl=N_stat/2;
  
% Autokorrelationsfunktion von x
rx=[rx zeros(1,N_stat-lge(rx))];  % einseitig
rx=[rx(lge(rx):-1:2) rx];         % zweiseitige Ergaenzung
  
% Systemstossantwort
dir=zeros(1,N_stat); dir(1)=1;  % dirac-Puls
h=filter(b,a,dir);              % Systemstossantwort

% Kreuzkorrelationsfunktion ryx
ryx=filter(h,1,rx);          % ryx[.] = h[.] * rx
ryx=ryx(N_stat:lge(ryx));    % Nullpunkt bei ryx[1]
 
 
 