 function plotn(f,d0,d1,d2,d3,d4,d5,d6,d7,d8,d9);

%PLOTM  Plots multiple vectors or matrices of possibly different sizes.
%       PLOTM(D0,D1,D2,D3,D4,D5,D6,D7,D8,D9) is similar to the PLOT command
%       with the advantage that the sizes of the (maximum 10) arguments 
%       need not be known a priori.
%       The line style is always 'solid'.
%
%       Example: (X is of length 3, Y is of length 5)
%                with PLOT one has to type PLOT(1:3,X,1:5,Y),
%                with PLOTM one just types PLOTM(X,Y).
%       f=figure handle

%      modified by Markus Hofbauer 11.97

figure(f);zoom on
hold off
for k = 1:nargin-1,
  eval(['len(' num2str(k) ') = length(d' num2str(k-1) ');']);
end;
 
Y = NaN * ones(max(len), nargin-1);
 
for k = 1:nargin-1,
  eval(['col = size(d' num2str(k-1) ',2);']);
  if col == 1,
    eval(['Y(1:len(' num2str(k) '),' num2str(k) ') = d' num2str(k-1) ';']);
  else
    eval(['tmp = d' num2str(k-1) ';']);
    Y(1:len(k), k) = tmp.';
  end;
end;
 
plot(Y);
