%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulation Nr. 3a  
%         
%         Funktion:
%         Hauptprogramm
%
%	  author:  Markus Hofbauer, Peter Wellig, Martin Haenggi
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  s3a_calc.m
%
%
% Startfile:  sim3a.m
%
% Hauptfile:  s4b_calc.m
% (wird aufgerufen)
%
% Benoetigte m-Files: im Verzeichnis sim3
%
%-------------------------------------------------------------------
%===================================================================




%===================================================================
% Vorbereitungen
%===================================================================

% message 
pause(0);                                 
set(htmess,'String',message_sim_lau_vor); % message
 
    % Hinweis: pause(0) wird jeweils eingesetzt, damit der 
    %          nachfolgende Befehl augenblicklich ausgefuehrt wird
 
%-------------------------------------------------------------------
% Lesen der Eingabeparameter
%------------------------------------------------------------------- 

p1=str2num(get(h1,'string'));
p2=str2num(get(h2,'string'));
p3=str2num(get(h3,'string'));
p4=str2num(get(h4,'string'));

ac=min(p1,99.999); set(h1,'string',num2str(ac))
sigma2Xcos=ac/(100-ac);
sigma2N=10^(p2/10); 
sn2=sigma2N;
loops=p3;
mu=p4;

%------------------------------------------------------------------- 
%  Initialisierungen und Definitionen
%------------------------------------------------------------------- 


% flags
busy_flag=1;
pause_flag=1;
termin_flag=0; 
error_flag=0;
stop_flag=0;
konv_flag=1;        

N            =   2;              % Anz. Filterkoeffizienten

% Signallaengen
len1    = 800;                   % Laenge der Sequenzen
len2   = len1-N+1;               % Plotlaenge 
len3   = 200; % round(len2/4);   % Mittelungslaenge fuer Jinf

% Parameter Eingangssignal
sigma2Xnoise =   1;              % Varianz von x[.]: Rauschanteil
alphaXcos    = 2*pi/15;          % Normierte Frequenz des Cosinus


Nstep       =   300;    % Anzahl Schritte Newton-/Grad.-Verfahren
cNewton     =     0.05; % Schrittweite Newton-Verfahren
cGrad       =     0.05; % Schrittweite Grad.-Verfahren

w2_range    =  -1.5:0.025:0.1;  % Bereich der Filterkoeffizienten fuer 
w1_range    =  -1.1:0.025:0.5;  % die Fehlerflaechendarstellung 

b = [0.15 -1.0]; a = [1];       % Filterkoeffizienten des Systems

N_stat       = 2048;
w_start      = zeros(N,1);   % Startwerte Filterkoeffizienten 
WW   = zeros(N,len1);
e2 = zeros(len2,loops) ;     % Fehlerquadrat

format compact;


%------------------------------------------------------------------- 
% Test auf Gueltigkeit der Eingabe
%------------------------------------------------------------------- 

if p1<0  | p2>10 | p3 < 1 | p4 < 0 
 set(htmess,'String',message_err); error_flag=1;
end 


%===================================================================
% Loop 
%===================================================================

if error_flag==0;        % falls gueltige Eingabe start loop

for i=1:loops            % Loop ueber Realisationen
  
 pause(0); 
 if stop_flag==1  stop_b ; return ; end       % stop ?  
 set(htmess,'String',message_sim_lau_lms);    % message  
 set(hta3,'String',num2str(i));               % message

%-------------------------------------------------------------------
% Generierung der Signale
%-------------------------------------------------------------------  

 [x,d,ws,normx]=signal(len1,sigma2Xnoise,sigma2Xcos,alphaXcos,sigma2N,b,a); 
   % x: Eingangssignal
   % d: erwuenschtes Signal
   % ws: Systemstossantwort
   
%-------------------------------------------------------------------
% Aufruf LMS - Algorithmus
%-------------------------------------------------------------------

 [e,W,w]=lms(mu,N,x,d,w_start);     % LMS-Algorithmus
   % e: Fehlersignal
   % W: Matrix aller Filtergewichte 
   % w: Gewichtsvektor nach Adaptionsende

  e2(:,i)=e(N:len1).*e(N:len1);      % Fehlerquadrat
  WW=WW+W(:,1:len1);                 % Addition Filterkoeffizienten
end;

%===================================================================
% Auswertung
%===================================================================

pause(0); 
set(htmess,'String',message_sim_lau_ausw); % message 
 
J=mean(e2',1);       % Ensemblemittelwert des quadr. Fehlers -> Lernkurve
WW=WW/loops;         % Ensemblemittelwert der Koeffizienten



%-----------------------------------------------------------------
% Berechnung der Statistik und der Wienerloesung
%-----------------------------------------------------------------

pause(0);
if stop_flag==1  stop_b ; return ; end   % stop ?



[R,rx]=calc_R(sigma2Xnoise,sigma2Xcos,alphaXcos,N,N_stat);
            % R: Autokorr. Matrix; rx: Autokorr. Funktion
ryx=calc_ryx(ws,1,rx,N_stat);
p=ryx(1:N)';                                  % p: Kreuzkorrelationsvektor

ry=calc_ry(ws,1,rx,N_stat);                   % ry:  Autokorr. Funktion von d'
sd2=ry(1)+sn2;                                % sd2: Varianz von d

pause(0);
if stop_flag==1  stop_b ; return ; end        % stop ?

% Wienerloesung
w0       = inv(R) * p;

% Jmin
Jmin     = abs(ry(1) -p'*w0 + sn2) ; % =  abs(sd2 - p'*w0);

% Konditionszahl
Kond     = cond(R);

%-------------------------------------------------------------------
% Newton-/Gradientenverfahren
%-------------------------------------------------------------------
pause(0);
if stop_flag==1  stop_b ; return ; end     % stop ?

% Newtonverfahren
wNewton  = newton(p, R, w_start, cNewton, Nstep);
w1Newton = wNewton(1,:);
w2Newton = wNewton(2,:);

% Gradientenverfahren
wGrad    = grad(p, R, w_start, cGrad, Nstep);
w1Grad   = wGrad(1,:);
w2Grad   = wGrad(2,:);


%-------------------------------------------------------------------
% Grenzwerte der Lernkurven, Fehleinstellung
%-------------------------------------------------------------------

pause(0);
if stop_flag==1  stop_b ; return ; end  

% Abschaetzung von J[ke], LMS
Jinf=mean(J(len2-len3:len2));       
if Jinf>10*sd2 | isnan(Jinf)        % keine Konvergenz, Schrittweite 
  konv_flag=0;                      % mu zu gross !
  Jinf=sd2;
end

% Plotparameter 
if Jinf <= Jmin   Jinf=Jmin* 1.00000001 ; end
if sn2==0 sn2db='-\infty';  else sn2db=10*log10(sn2) ; end 
if Jmin==0 Jmindb='-\infty'; else Jmindb=10*log10(Jmin) ; end 

%===================================================================
% Graphik
%===================================================================

pause(0);  
set(htmess,'String',message_sim_lau_gra);  % message
if stop_flag==1  stop_b ; return ; end     % stop ?

%-------------------------------------------------------------------
%  Lernkurve, quadratischer Fehler
%-------------------------------------------------------------------

% figur(2)

f2=figure(2); clf; 
if first_time set(f2,'position', [569 151 705 735 ]); end;
 

% subplot 1, quadratischer Fehler
subplot('position',[0.13 0.62 0.77 0.32]); 
  plot(db(e2(:,i))); grid;  xlabel('k')
  axis([0 len2 db(Jmin/10)  db(sd2*10)]);
  ax1=axis; yrange=ax1(4)-ax1(3);
  title(['LMS: quadrierter Adaptionsfehler e[k]^2 (LMS Nr. ',num2str(i),')']);
  plotypos1=max(db(Jmin)+0.06*yrange,db(Jinf));
  plotypos1b=max(db(Jmin)+0.01*yrange,db(Jinf));
  hold on;
  plot(db(sd2*ones(1,len2)),'r');
  plot(db(Jmin*ones(1,len2)),'r');
  text(-len2*0.08,ax1(4)+yrange*0.05,'[dB]')
  text(-len2*0.15,db(Jmin),'J_{min}')
  text(-len2*0.15,db(sd2),'J[0] = \sigma_d^2')
  text(len2*1.01,db(sd2),[sprintf('%1.1f',10*log10(sd2)),' dB'])
  text(len2*1.01,db(Jmin),[sprintf('%1.1f',10*log10(Jmin)),' dB'])

% subplot 2,  LMS-Lernkurve 
subplot('position',[0.13 0.2 0.77 0.32]);
  plot(db(J)); grid; xlabel('k') 
  axis([0 len2 db(Jmin/10)  db(sd2*10)]);
  ax1=axis; yrange=ax1(4)-ax1(3);
  title(['LMS:  Lernkurve J[k] = E[ e[k]^2 ]   (Schaetzung aus ',num2str(loops),' Realisationen)']);
  plotypos2=max(db(Jmin)+0.06*yrange,db(Jinf));
  plotypos2b=max(db(Jmin)+0.01*yrange,db(Jinf));
  hold on;
  plot(plotypos2b*ones(1,len2),'g');
  plot(db(sd2*ones(1,len2)),'r');
  plot(db(Jmin*ones(1,len2)),'r');
  text(-len2*0.08,ax1(4)+yrange*0.05,'[dB]')
  text(-len2*0.15,plotypos2,'J[k_e]')
  text(-len2*0.15,db(Jmin),'J_{min}')
  text(len2*1.01,plotypos2,[sprintf('%1.1f',10*log10(Jinf)),' dB'])
  text(-len2*0.15,db(sd2),'J[0] = \sigma_d^2')
  text(len2*1.01,db(sd2),[sprintf('%1.1f',10*log10(sd2)),' dB'])
  text(len2*1.01,db(Jmin),[sprintf('%1.1f',10*log10(Jmin)),' dB'])
 
% Ausgabe der Kennwerte
su=subplot('position',[0.05 0.01 0.9 0.10]);
  set(su,'ytick',NaN); set(su,'xtick',NaN); set(su,'box','on');
  set(su,'color',[0.75 0.75 0.75]);
  text(0.05,0.6,['\sigma_n^2 =  ',sprintf('%1.1f',sn2db),' dB'])
  text(0.4,0.6,['J_{min} (fuer N = ',num2str(N),') =  ',sprintf('%1.1f',Jmindb),' dB'])
  text(0.8,0.6,['J_{ex} = J[k_e] - J_{min}'])


%-------------------------------------------------------------------
% zeitlicher Verlauf der Filterkoeffizienten
%-------------------------------------------------------------------

% figur(3)

f3=figure(3); clf; 
if first_time set(f3,'position', [370 7 608 425]); end; 

subplot(211);
  plot(W(:,N:len1)'); grid; xlabel('k'); ylabel('w_1  w_2');
  title(['LMS: Adaption der Gewichte w_1, w_2   (LMS Nr. ',num2str(loops),')']);
  axis([0 len2 -1.5 1.5]);

subplot(212);
  plot(WW(:,N:len1)'); grid; xlabel('k'); ylabel('w_1  w_2');
  title('LMS: Adaption der Gewichte w_1, w_2   (Ensemblemittel E[ w ])');
  axis([0 len2 -1.5 1.5]);


%-------------------------------------------------------------------
% Darstellung des Rekursionsverlaufs verschiendenen 
% Adaptionsalgorithmen im Contourplot
%-------------------------------------------------------------------

% figur(4)

pause(0);  
if stop_flag==1  stop_b ; return ; end    % stop ?

f4=figure(4); clf; 
if first_time set(f4,'Position',[8 520 547 421]); end; 

% Fehlerflaeche
Jflaeche = calcJ(sd2, p, R, w1_range, w2_range);

% contourplot
contour(w1_range, w2_range, Jflaeche, linspace(Jmin,max(max(Jflaeche)),50));
hold on;

w1LMS = W(1,:);    % LMS-Filterkoeffizient Nr 1, zeitlicher Verlauf
w2LMS = W(2,:);
ww1LMS = WW(1,:);  % Ensemblemittelwert des LMS-Filterkoeffizient Nr 1,
ww2LMS = WW(2,:);  % zeitlicher Verlauf

line(w1LMS,   w2LMS,   'color',[0,0,1]);
line(ww1LMS,  ww2LMS,  'color',[0,1,1]);
line(w1Grad,  w2Grad,  'color',[1,0,0]);
line(w1Newton,w2Newton,'color',[0,1,0]);

xlabel('W1');
ylabel('W2');

plot(w0(1),w0(2),'x');
hold off;
axis([w1_range(1),w1_range(lge(w1_range)),0.8*w2_range(1),w2_range(lge(w2_range))]);
axis('equal');

grid;
title('Rekursionsverlauf verschiedener Adaptionsalgorithmen (2D, Contourplot)');
xlabel('w_1');
ylabel('w_2');
legend('LMS','E[LMS]  (Ensemblemittel)','Gradient','Newton',3);

pause(0);  
if stop_flag==1  stop_b ; return ; end  

%-------------------------------------------------------------------
% Darstellung des Rekursionsverlaufs der verschiedenen
% Adaptionsalgorithmen auf der Fehlerflaeche
%-------------------------------------------------------------------

% figur(5)

f5=figure(5); clf; 
if first_time set(figure(5),'Position', [567 520 575 420]); end;

% 3D plot der Fehlerflaeche
mesh(w1_range ,w2_range, Jflaeche);
view(-10,44)

ax = axis;
axis([w1_range(1), w1_range(length(w1_range)), ...
      w2_range(1), w2_range(length(w2_range)), ...
      ax(5), ax(6)]);

hold on;
offset = 0.05;

JLMS     = calcJ(sd2, p, R, W);
JELMS    = calcJ(sd2, p, R, WW);
JNewton  = calcJ(sd2, p, R, wNewton);
JGrad    = calcJ(sd2, p, R, wGrad);

line(w1LMS,   w2LMS,   JLMS+offset,   'color',[0,0,1],'linewidth',2);
line(ww1LMS,  ww2LMS,  JELMS+offset,  'color',[0,1,1],'linewidth',2);
line(w1Grad,  w2Grad,  JGrad+offset,  'color',[1,0,0],'linewidth',2);
line(w1Newton,w2Newton,JNewton+offset,'color',[0,1,0],'linewidth',2);

xlabel('w_1');
ylabel('w_2');
zlabel('J');
title('Rekursionsverlauf verschiedener Adaptionsalgorithmen (Fehlerflaeche)');
hold off;
legend('LMS','E[LMS] (Ensemblemittel)','Gradient','Newton',2);

%===================================================================
% I/0 Fenster, Ausgabe 
%===================================================================

set(hta1,'String',num2str(N)); 
set(hta2,'String',num2str(mu));
set(hta4,'String',num2str(Kond));
set(htmess,'String',message_sim_abg); 


first_time=0;

end;   % end (if error_flag==0)

%-------------------------------------------------------------------
% Abschluss
%-------------------------------------------------------------------

busy_flag=0;

if konv_flag==0  set(htmess,'String',message_konv); end;
if termin_flag==1; terminate; end

%============================== end ================================


