%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulation Nr. 3b  
%         
%         Funktion:
%         Hauptprogramm
%
%	  author:  Markus Hofbauer, Peter Wellig, Martin Haenggi
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  s3b_calc.m
%
%
% Startfile:  sim3b.m
%
% Hauptfile:  s3b_calc.m
% (wird aufgerufen)
%
% Benoetigte m-Files: im Verzeichnis sim3
%
%-------------------------------------------------------------------
%===================================================================




%===================================================================
% Vorbereitungen
%===================================================================

% message 
pause(0);                                  
set(htmess,'String',message_sim_lau_vor);  % message

   % Hinweis: pause(0) wird jeweils eingesetzt, damit der 
   %          nachfolgende Befehl augenblicklich ausgefuehrt wird
 
%-------------------------------------------------------------------
% Lesen der Eingabeparameter
%------------------------------------------------------------------- 

p1=str2num(get(h1,'string'));
p2=str2num(get(h2,'string'));
p3=str2num(get(h3,'string'));
p4=str2num(get(h4,'string'));
p5=str2num(get(h5,'string'));

ac=min(p1,99.999); set(h1,'string',num2str(ac))
sigma2Xcos=ac/(100-ac);
sigma2N=10^(p2/10); 
sn2=sigma2N;
loops=p3;
mus=sort(p4);
Ns=sort(p5);

%------------------------------------------------------------------- 
%  Initialisierungen und Definitionen
%------------------------------------------------------------------- 

% flags
busy_flag=1;
pause_flag=1;
termin_flag=0; 
error_flag=0;
stop_flag=0;
konv_flag=1;        
N_mu_flag=0;

% Signallaengen
len1    = 1000;                   % Laenge der Signale
len2   = len1-max(Ns)+1;          % Plotlaenge 
len3   = 200 ; %round(len2/2);    % Mittelungslaenge fuer Jinf

% Parameter Eingangssignal
sigma2Xnoise =   1;               % Varianz von x[.]: Rauschanteil
alphaXcos    = 2*pi/10;           % Normierte Frequenz des Cosinus


N_stat       = 2048;              % Parameter fuer calc_x.m
a = [1 0.4]; b = [1];             % Filterkoeffizienten des Systems

clear J Jinf Jmin e2;

format compact;


% Listen aller mu und N
mule=length(mus);     % Laenge Liste mu
Nle=length(Ns);       % Laenge Liste N
listle=max(Nle,mule);
if mule > 1               % mu-Liste wurde eigegeben 
  Ns=ones(listle,1)*Ns ; 
else                      % N-Liste wurde eigegeben 
  mus=ones(listle,1)*mus ; N_mu_flag=1; 
end  

%------------------------------------------------------------------- 
% Test auf Gueltigkeit der Eingabe
%------------------------------------------------------------------- 

if p1<0  | p2>10 | p3 < 1
 set(htmess,'String',message_err); error_flag=1;
elseif (mule > 1 & Nle > 1 )| min(p4) < 0 | min(p5)< 1 
 set(htmess,'String',message_err); error_flag=1; 
end 

%===================================================================
% Loop 
%===================================================================

if error_flag==0;                % falls gueltige Eingabe start loop

for j=1:listle;                  % Loop ueber alle mu und N
  
  N=Ns(j); mu=mus(j);
  w_start = zeros(N,1);          % Startwerte Filterkoeffizienten 
  WW=zeros(N,len1);
  clear e2;
  
  pause(0); 
  set(hta1,'String',num2str(N));     % message
  set(hta2,'String',num2str(mu));    % message
  pause(0); 
 
  for i=1:loops      % Loop ueber Realisationen
  
    pause(0); 
    if stop_flag==1  stop_b ; return ; end   % stop ? 
    set(hta3,'String',num2str(i));    % message

%-------------------------------------------------------------------
% Generierung Signale
%-------------------------------------------------------------------

    [x,d,ws,normx]=signal(len1,sigma2Xnoise,sigma2Xcos,alphaXcos,sigma2N,b,a); 
      % x: Eingangssignal
      % d: erwuenschtes Signal
      % ws: Systemstossantwort

%-------------------------------------------------------------------
% Aufruf LMS - Algorithmus
%-------------------------------------------------------------------
    pause(0); 
    set(htmess,'String',message_sim_lau_lms);   % message
    
    [e,W,w]=lms(mu,N,x,d,w_start);
      % e: Fehlersignal
      % W: Matrix aller Filtergewichte 
      % w: Gewichtsvektor nach Adaptionsende

    e2(:,i)=e(N:len1).*e(N:len1);      % Fehlerquadrat
    WW=WW+W(:,1:len1);                 % Addition Filterkoeffizienten
 
  end;   %end (for i=1:loops)

  J(j,1:lge(e2)) =mean(e2',1);   
                      % Ensemblemittelwert des quadr. Fehlers -> % Lernkurve 
  Jinf(j)=mean(J(j,len2-len3:len2)); 
                      % Abschaetzung von J[ke], LMS 
  
end;   %end (for j=1:listle)

WW=WW/loops;         % Ensemblemittelwert der Koeffizienten

%===================================================================
% Auswertung
%===================================================================

pause(0); 
set(htmess,'String',message_sim_lau_ausw);  % message

%-------------------------------------------------------------------
% Berechnung der Statistik und der Wienerloesung
%-------------------------------------------------------------------

if N_mu_flag==1 Ns2=Ns; else Ns2=Ns(1); end;

for st=1:lge(Ns2)   % Statistik in Abhaengigkeit von N 
  
  N=Ns2(st);  

  [R,rx]=calc_R(sigma2Xnoise,sigma2Xcos,alphaXcos,N,N_stat);
                         % R: Autokorr. Matrix; rx: Autokorr. Funktion
  ryx=calc_ryx(ws',1,rx,N_stat);
  p=ryx(1:N)';                             % p: Kreuzkorrelationsvektor
   
  ry=calc_ry(ws',1,rx,N_stat);             % ry:  Autokorr. Funktion von d'
  sd2=ry(1)+sn2;                           % sd2: Varianz von d
   
  % Wienerloesung
  w0 = inv(R) * p;

  % Jmin
  Jmin(st)  = abs(ry(1) -p'*w0 + sn2);  
    
  pause(0);
  if stop_flag==1  stop_b ; return ; end   % stop ?

end;

% Konditionszahl
Kond     = cond(R);

%-------------------------------------------------------------------
% Grenzwerte der Lernkurven
%-------------------------------------------------------------------

% Abschaetzung von J[ke], LMS
testJ=Jinf>10*sd2;
if  sum(testJ)>0| isnan(sum(Jinf))    % keine Konvergenz, Schrittweite 
   konv_flag=0;                       % mu zu gross 
   Jinf=sd2*ones(1,listle);
end


%-------------------------------------------------------------------
% Berechnung des Systemfehlermasses
%-------------------------------------------------------------------

dw0=ws- [w0;zeros(length(ws)-N,1)];
dw=ws- [w;zeros(length(ws)-N,1)];

dw0_db=db(sum(dw0.^2)/sum(ws.^2));
dw1_db=db(sum(dw.^2)/sum(ws.^2));



%===================================================================
% Graphik
%===================================================================

pause(0);  
set(htmess,'String',message_sim_lau_gra); 
if stop_flag==1  stop_b ; return ; end  

%-------------------------------------------------------------------
% Lernkurven
%-------------------------------------------------------------------

% figur(2)

f2=figure(2); clf; 
if first_time set(f2,'position', [610 443 664 498 ]);  end; 

plot(db(J')); grid; xlabel('k'); ylabel('J[k]       [dB]');

if N_mu_flag==0 
  titlestr=' LMS Lernkurven in Abhaengigkeit von \mu ';
  legend(num2str(mus'))  
else 
 if Nle>1 
   titlestr='LMS Lernkurven in Abhaengigkeit von N '; 
   legend(num2str([Ns]')); 
 else 
   titlestr='LMS Lernkurve';
 end 
end  
title(titlestr); 


%-------------------------------------------------------------------
% zeitlicher Verlauf der Filterkoeffizienten
%-------------------------------------------------------------------

% figur(3)

f3=figure(3); clf; 
if first_time set(f3,'position', [8 513 529 428 ]);  end;

subplot(211);
  plot(W(:,N:len1)'); grid; xlabel('k'); ylabel('w ');
  title(['LMS: Adaption der N = ',num2str(N),' Gewichte    (LMS Nr. ',num2str(i),')']);
  axis([0 len2 -1.5 1.5]);

subplot(212);
  plot(WW(:,N:len1)'); grid; xlabel('k'); ylabel('w ');
  title(['LMS: Adaption der  N = ',num2str(N),' Gewichte  (Ensemblemittel E[ w ])']);
  axis([0 len2 -1.5 1.5]);

pause(0);  
if stop_flag==1  stop_b ; return ; end    % stop ?


%-------------------------------------------------------------------
% J[ke] und Jmin in Abhaengigkeit von mu bzw N
%-------------------------------------------------------------------

% figur(4)

f4=figure(4); clf;
if first_time  set(f4,'position', [ 611 7 664 498 ]);  end;

if N_mu_flag==1	  %  in Abhaengigkeit von N
  if Nle >1 
    patch([Ns Ns(listle:-1:1)],[db(Jmin) db(Jinf(listle:-1:1))],[1 1 0]);
  end
  hold on ; grid;
  plot(Ns,db(Jinf),'b');;
  plot(Ns,db(Jmin),'r');
  plot(Ns,db(Jinf),'b*');
  plot(Ns,db(Jmin),'r*');
  ax=axis; axis([ax(1) ax(2) 1.01*ax(3) ax(4)]);
  xlabel(' N '); ylabel('J[k_e]        [dB]');
  title(['J[k_e] und J_{min} in Abhaengigkeit von N']);
  legend('J[k_e]','J_{min}',4);

else              %  in Abhaengigkeit von mu

  patch([mus mus(listle:-1:1)],[db(Jmin*ones(1,listle)) db(Jinf(listle:-1:1))],[1 1 0]);
  hold on ; grid;
  plot(mus,db(Jinf),'b'); 
  plot(mus,db(Jmin)*ones(1,lge(mus)),'r');
  plot(mus,db(Jinf),'b*');
  plot(mus,db(Jmin),'r*');
  ax=axis; axis([ax(1) ax(2) 1.01*ax(3) ax(4)]);
  xlabel('\mu'); ylabel('J[k_e]    [dB]');
  title(['J[k_e]  in Abhaengigkeit von \mu']);
  legend('J[k_e]','J_{min}',4);

end


%-------------------------------------------------------------------
% Vergleich der Filtergewichte mit der Systemantwort
%-------------------------------------------------------------------

% figur(5)

f5=figure(5); clf; 
if first_time set(f5,'position', [372 10 664 720]);  end; 

% subplot 1, Vergleich mit der Systemantwort 
subplot(211)
  axis([1 lge(ws) 1.2*min([ws;w]) 1.2*max([ws;w])])
  ax=axis;
  yrange1=(ax(4)-ax(3)) ;
  patch([ax(1) ax(1) N N ax(1)],[ax(3) ax(4) ax(4) ax(3) ax(3)],[0.9 0.9 0.9])
  hold on;
  plot(ws,'b')
  plot(w0,'g')
  plot(w,'r')
  plot(ws,'b')
  line([N N+4],(ax(4)-0.1*yrange1)*[1 1]); text(N+5,(ax(4)-0.1*yrange1),'identifizierter')
  text(N+5,(ax(4)-0.2*yrange1),'Teil')
  title('Vergleich der Filter mit der Systemantwort')
  xlabel('Index Koeffizienten ')
  ylabel('w')
  legend('System','Wienerloesung','LMS',4)

% subplot 1, Abweichung von der Systemantwort 
su=subplot(212);  
  ps=get(su,'position'); set(su,'position',[ps(1) 1.4*ps(2) ps(3) ps(4)]);
  dw1=ws- [w0;zeros(length(ws)-N,1)];
  dw2=ws- [w;zeros(length(ws)-N,1)];
  axis([1 lge(ws) 1.2*min([dw2]) 1.2*max([dw2])])
  ax=axis;
  patch([ax(1) ax(1) N N ax(1)],[ax(3) ax(4) ax(4) ax(3) ax(3)],[0.9 0.9 0.9])
  hold on;
  plot(dw1,'g')
  plot(dw2,'r')
  title('Abweichung der Filter von der Systemantwort')
  xlabel('Index Koeffizienten ')
  ylabel('\Delta w')
  legend('Wienerloesung','LMS',4)

% Ausgabe des System-Fehler-Masses
su=subplot('position',[0.05 0.01 0.9 0.08]);
  set(su,'ytick',NaN); set(su,'xtick',NaN); set(su,'box','on');
  set(su,'color',[0.75 0.75 0.75]);
  text(0.02,0.5,'System-Fehler-Mass:')
  text(0.35,0.4,['\Deltaw_{dB (Wiener)} = ',sprintf('%1.1f',dw0_db),' dB']);
  text(0.7,0.4,['\Deltaw_{dB (LMS)}   = ',sprintf('%1.1f',dw1_db),' dB']);

  
%===================================================================
% I/0 Fenster, Ausgabe 
%===================================================================


set(hta4,'String',num2str(Kond));
set(htmess,'String',message_sim_abg); 


first_time=0;

end;    % end (if error_flag==0)


%-------------------------------------------------------------------
% Abschluss
%-------------------------------------------------------------------

busy_flag=0;

if konv_flag==0  set(htmess,'String',message_konv); end;
if termin_flag==1; terminate; end

%============================== end ================================






