%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulation Nr. 3a  
%         
%         Funktion:
%         Einrichten des gui Ein- und Ausgabefensters
%         und Aufruf des Hauptprogramms
%
%	  author:  Markus Hofbauer,
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  sim3a.m
%
%
% Startfile:  sim3a.m
%
% Hauptfile:  s3a_calc.m
% (wird aufgerufen)
%
% Benoetigte m-Files: im Verzeichnis sim3
%
%-------------------------------------------------------------------
%===================================================================




%===================================================================
% Initialisierung und Definitionen
%===================================================================

% close/clear all

figure(1); close 1;
close all; clear;


% Definition globaler Variablen

global stop_flag
stop_flag=0;
global busy_flag
busy_flag=0;
global termin_flag
termin_flag=0;
global pause_flag;
pause_flag=1;
global contin_flag;
contin_flag=0;

first_time=1;

%-------------------------------------------------------------------
% Koordinatendefinitionen des IO-Fensters
%-------------------------------------------------------------------


% IO-Fenster
wb=350; wh=500;           % Breite, Hoehe
iowinpos=[10 10 wb wh];   % Position

% Eingabefelder

fb=60;                       % Feldbreite
fh=20;                       % Feldhoehe wird noch veraendert
fa=30;                       % Feldabstand vertikal
sp1=20; sp2=160 ; sp3=225;   % 1,2,3. Spalte
re1=wh-80; re2= 0.35*wh;     % 1. und 2. Zeile (Eingabe und Ausgabe)
kor=5;                       % Korrektur 

%-------------------------------------------------------------------
% I/O Figur Initialisierung
%-------------------------------------------------------------------

f_IO=figure('resize','off','numbertitle','off','name','I/0','Position',iowinpos);
axes ; axis off;
ha=get(f_IO,'children'); 
set(ha,'position',[0 0 1 1],'xlim',[0 wb],'ylim',[0 wh]);
fontsi=get(ha,'fontsize');
patch([0 wb wb 0 0],[0 0 re2  re2 0],[0.75 0.75 0.75])
patch([0 wb wb 0 0],[re2+50 re2+50  re1 re1 re2+50],[0.75 0.75 0.75])


%===================================================================
%  Definition der Ein- und Ausgabeparameter
%===================================================================

% aufgerufenes Hauptprogramm
callfile='s3a_calc';      % wird von start aufgerufen 

%-------------------------------------------------------------------
%  Eingabeparameter
%-------------------------------------------------------------------

p1str='cos-Anteil von x:      a_c';    % label Parameter 1
p1init=90 ;                            % initwert 
p1message='%' ;                        % Zusatz label

p2str='\sigma^2_n : ';  
p2init=-30  ;
p2message='dB  ( < 0 ) ' ; 

p3str='# Realisationen : ';  
p3init=20  ;
p3message=''; 

p4str='\mu : ';  
p4init=0.05  ;
p4message='' ; 

%-------------------------------------------------------------------
% Ausgabeparameter
%-------------------------------------------------------------------

pa1str='N : ';  
pa1init='' ;

pa2str='\mu : ';  
pa2init=''  ;

pa3str='Realisation Nr. : ';  
pa3init=''  ;

pa4str='\chi({\bfR}) : ';  
pa4init=''  ;

%-------------------------------------------------------------------
% messages
%-------------------------------------------------------------------

message_init='';
message_err='ungeeignete Eingabe  !';
message_konv='keine Konvergenz, \mu zu gross !';
message_sim_lau='Simulation laeuft : ';
message_sim_lau_vor='Simulation laeuft : Vorbereitung';
message_sim_lau_lms='Simulation laeuft : LMS-Alg.';
message_sim_lau_rls='Simulation laeuft : RLS-Alg.';
message_sim_lau_flms='Simulation laeuft : FLMS-Alg.';
message_sim_lau_ausw='Simulation laeuft : Auswertung';
message_sim_lau_gra='Simulation laeuft : Graphik';
message_sim_stop='Simulation gestoppt';
message_sim_wstop='Simulation wird gestoppt';
message_sim_abg='Simulation abgeschlossen';
message_sim_start='Simulation laeuft bereits';


%===================================================================
% gui mit den definierten Ein- und Ausgabeparametern
%===================================================================


%-------------------------------------------------------------------
% buttons
%-------------------------------------------------------------------

% Start
hstart=uicontrol(f_IO,'Style','pushbutton','Position',[wb-210 re1+40 100 ...
      23],'String','Start','CallBack','start','ForegroundColor',[1 1 0] );   


% Ende
hterm=uicontrol(f_IO,'Style','pushbutton','Position',[wb-105 re1+15 100 ...
      23],'String','Ende','CallBack','terminate','ForegroundColor',[1 1 ...
      0] );  

% Stop
hstop=uicontrol(f_IO,'Style','pushbutton','Position',[wb-105 re1+40 100 ...
      23],'String','Stop','CallBack','stop_a;','ForegroundColor',[1 1 ...
      0] );  

% Init Werte
hinit=uicontrol(f_IO,'Style','pushbutton','Position',[wb-210 re1+15 100 ...
      23],'String','Init Werte','CallBack','setinitval','ForegroundColor',[1 1 0] );  

%-------------------------------------------------------------------
% Eingabefelder
%-------------------------------------------------------------------
 
% Eingabe
 uicontrol(f_IO,'Style','text','Position',[sp1 re1+40 100 ...
       23],'string','Eingabe:','ForegroundColor',[1 1 0],'FontSize',1.5*fontsi);

% parameter 1
h1=uicontrol(f_IO,'Style','edit','Position',[sp2  re1-fa fb ...
      fh],'string',num2str(p1init),'ForegroundColor',[1 1 0]);
   text(sp1,re1-fa+fh/2-kor,p1str);
   ht1=text('Position',[sp3 re1-fa+fh/2]);
   set(ht1,'String',p1message);

% parameter 2
h2=uicontrol(f_IO,'Style','edit','Position',[sp2  re1-2*fa fb ...
      fh],'string',num2str(p2init),'ForegroundColor',[1 1 0]);
   text(sp1,re1-2*fa+fh/2-kor,p2str);
   ht2=text('Position',[sp3 re1-2*fa+fh/2]);
   set(ht2,'String',p2message);

% parameter 3
h3=uicontrol(f_IO,'Style','edit','Position',[sp2  re1-3*fa fb ...
      fh],'string',num2str(p3init),'ForegroundColor',[1 1 0]);
   text(sp1,re1-3*fa+fh/2,p3str);
   ht3=text('Position',[sp3 re1-3*fa+fh/2]);
   set(ht3,'String',p3message);

% parameter 4
h4=uicontrol(f_IO,'Style','edit','Position',[sp2  re1-4*fa fb ...
      fh],'string',num2str(p4init),'ForegroundColor',[1 1 0]); 
  text(sp1,re1-4*fa+fh/2,p4str);
  ht4=text('Position',[sp3 re1-4*fa+fh/2]);
  set(ht4,'String',p4message);


handle_list=[h1 p1init ; h2 p2init ; h3 p3init ; h4 p4init];

%-------------------------------------------------------------------  
% Ausgabefelder
%-------------------------------------------------------------------

% Ausgabe  
uicontrol(f_IO,'Style','text','Position',[sp1 re2+10 100 ...
      23],'string','Ausgabe:','ForegroundColor',[1 0 0],'FontSize',1.5*fontsi);

% message
htmess=text('Position',[sp2 re2+15]);
set(htmess,'String',message_init);

% parameter 1
text(sp1,re2-2*fa+fh/2,pa1str);
  hta1=text('Position',[sp2 re2-2*fa+fh/2]);
  set(hta1,'String',num2str(pa1init));

% parameter 2
text(sp1,re2-3*fa+fh/2,pa2str);
  hta2=text('Position',[sp2 re2-3*fa+fh/2]);
  set(hta2,'String',num2str(pa1init));

% parameter 3
text(sp1,re2-1*fa+fh/2,pa3str);
  hta3=text('Position',[sp2 re2-1*fa+fh/2]);
  set(hta3,'String',num2str(pa1init));

% parameter 4
text(sp1,re2-4*fa+fh/2,pa4str);
  hta4=text('Position',[sp2 re2-4*fa+fh/2]);
  set(hta4,'String',num2str(pa1init));
  
%-------------------------------------------------------------------
%
%-------------------------------------------------------------------

set(f_IO,'handlevisibility','off')    % verhindert versehentliches
                                      % zeichnen in I/O Fenster


%============================== end ================================