%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulationen  
%         
%         [J] = calcJ(sd2, p, R, arg1, arg2);
%
%         Berechnet die Fehlerflaeche oder den Rekursionsverlauf 
%         eines Algorithmus auf der Fehlerflaeche
%
%         falls nur arg1 angegeben:
%           arg1 : 2xlen Matrix, zeitlicher Verlauf von w 
%         falls arg1 und arg2 angegeben:
%           arg1 enthaelt die w1- und arg2 die
%           w2-Werte fuer die die Fehlerflaeche berechnet wird
%
%-------------------------------------------------------------------

%
%
%	  author:  Pascal Vontobel & Dieter Arnold
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  calcJ.m
%
% Startfile:  simX.m
%
%-------------------------------------------------------------------
%===================================================================


function [J] = calcJ(sd2, p, R, arg1, arg2);

if (nargin==4);
  w = arg1;
  J = zeros(1,size(w,2));

  for ii=1:size(w,2);
    J(ii) = sd2 - 2*p'*w(:,ii) + w(:,ii)'*R*w(:,ii);
  end;
elseif (nargin==5);
  J = zeros(length(arg2),length(arg1));
  
  for ii=1:length(arg1);
    for jj=1:length(arg2);
      w = [arg1(ii), arg2(jj)]';
      J(jj,ii) = sd2 - 2*p'*w + w'*R*w;
    end;
  end;
end;
