%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulationen  
%         
%         [R,rx]=calc_R(sigma2Xnoise,sigma2Xcos,alphaXcos,N,N_stat);
%
%         Berechnung der Autokorrelations- Funktion und Matrix
%         Eingangssignal: x = cos + weisses Rauschen
%
%              R: Autokorrelationsmatrix
%              rx: Autokorrelationsfunktion
%
%              sigma2Xnoise: Varianz  weisses Rauschen   
%              sigma2Xcos: Varianz cos
%              alphaXcos: Normierte Frequenz cos
%              N: Dimension N x N von R
%              N_stat: Laenge von rx              
%
%-------------------------------------------------------------------

%
%	  author:  Markus Hofbauer,
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  calc_R.m
%
% Startfile:  simX.m
%
%-------------------------------------------------------------------
%===================================================================


function [R,rx]=calc_R(sigma2Xnoise,sigma2Xcos,alphaXcos,N,N_stat);

R=zeros(N,N);

rcos=sigma2Xcos*cos([0:N_stat-1]*alphaXcos);
rn=zeros(1,N_stat); rn(1)=sigma2Xnoise;

rx=(rcos+rn)/(sigma2Xnoise+sigma2Xcos);

r=rx(1:N);
R=toeplitz(r,r);
 
