%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulationen  
%         
%         [wGrad] = grad(p, R, w_start, cGrad, Nstep);
%
%         Gradienten-Verfahren
%
%         wGrad    = Filterkoeffizienten im zeitlichen Verlauf
%         p        = Kreuzkorrelationsvektor p
%         R        = Autokorrelationsmatrix R
%         w_start  = Startwerte Filterkoeffizienten 
%         cGrad  = Schrittweite
%         Nstep    = Anzahl Iterationen
%
%
%-------------------------------------------------------------------

%
%	  author:  Pascal Vontobel & Dieter Arnold
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  grad.m
%
% Startfile:  simX.m
%
%-------------------------------------------------------------------
%===================================================================

function [wGrad] = grad(p, R, w_start, cGrad, Nstep);

N            = length(w_start);   % Anzahl Filterkoeffizienten
                                  % des FIR-Filters

wGrad        = zeros(N,Nstep);    % Initialisierung
wGrad(:,1)   = w_start;           % Startwert

for nn=1:Nstep-1;                 % Iterationsloop
  Gradient          = 2*(R*wGrad(:,nn) - p);
                                  % Gradientenberechnung
  wGrad(:,nn+1)     = wGrad(:,nn) - cGrad * Gradient;
                                  % Aufdatierung der Filterkoeffizienten
end;


