%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulationen  
%         
%         [E,W,w,DD]=lms(mu, N, X, D, w_start)
%
%         LMS-Algorithmus
%
%         E  = Fehlersignal E[.]
%         W  = Filterkoeffizienten im zeitlichen Verlauf
%         w  = Filterkoeffizienten am Ende der Adaption
%         DD = Filterausgang, Schaetzung von D
%         mu = Schrittweite
%         N  = Anz. Filterkoeffizienten = Filterordnung+1
%         X  = Filtereingang X[.]
%         D  = erwuenschtes Signal D[.]
%         w_start = Startwerte Filterkoeffizienten 
%
%-------------------------------------------------------------------

%
%	  author:  Peter Wellig, Martin Haenggi, Markus Hofbauer
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  lms.m
%
% Startfile:  simX.m
%
%-------------------------------------------------------------------
%===================================================================

function [E,W,w,DD]=lms(mu, N, X, D, w_start)

% Initialisierungen
adaptlen=length(X);       
w = w_start;                
W=zeros(N,adaptlen);
DD=zeros(adaptlen,1); 
E=zeros(adaptlen,1); 


% Loop

for i=N:adaptlen
  W(:,i) = w;

  x      = X(i:-1:i-N+1); % Eingangsvektor (x[k],x[k-1],..,x[k-N+1])
  y      = x'*w;          % Filterausgang 
  e      = D(i)-y;        % Fehler     
  w      = w+mu*e*x;      % Aufdatierung der Filterkoeffizienten

  E(i)   = e;   
  DD(i)  = y;
end; 





