%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulationen  
%         
%         [E,W,w]=lms_newton(mu, N, X, D, w_start,invR)
%
%         Newton-LMS-Algorithmus
%
%         E  = Fehlersignal E[.]
%         W  = Filterkoeffizienten im zeitlichen Verlauf
%         w  = Filterkoeffizienten am Ende der Adaption
%         mu = Schrittweite
%         N  = Anz. Filterkoeffizienten = Filterordnung+1
%         X  = Filtereingang X[.]
%         D  = erwuenschtes Signal D[.]
%         w_start = Startwerte Filterkoeffizienten 
%         invR = Inverse der Autokorrelationsmatrix
%
%-------------------------------------------------------------------

%
%	  author:  Markus Hofbauer
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  lms_newton.m
%
% Startfile:  simX.m
%
%-------------------------------------------------------------------
%===================================================================

function [E,W,w]=lms_newton(mu, N, X, D, w_start,invR)

% Initialisierungen
adaptlen=length(X);
w = w_start;             
W=zeros(N,adaptlen);
E=zeros(adaptlen,1); 

% Loop

for i=N:adaptlen
  W(:,i) = w;

  x      = X(i:-1:i-N+1); % Eingangsvektor (x[k],x[k-1],..,x[k-N+1])
  y      = x'*w;          % Filterausgang 
  e      = D(i)-y;        % Fehler       
  w      = w+mu*invR*e*x; % Aufdatierung der Filterkoeffizienten 

  E(i)   = e;
end;



