%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulationen  
%         
%         [wNewton] = grad(p, R, w_start, cNewton, Nstep);
%
%         Newton-Verfahren
%
%         wNewton    = Filterkoeffizienten im zeitlichen Verlauf
%         p        = Kreuzkorrelationsvektor p
%         R        = Autokorrelationsmatrix R
%         w_start  = Startwerte Filterkoeffizienten 
%         cNewton  = Schrittweite
%         Nstep    = Anzahl Iterationen
%
%
%-------------------------------------------------------------------

%
%	  author:  Pascal Vontobel & Dieter Arnold
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  newton.m
%
% Startfile:  simX.m
%
%-------------------------------------------------------------------
%===================================================================



function [wNewton] = newton(p, R, w_start, cNewton, Nstep);

N            = length(w_start);   % Anzahl Filterkoeffizienten
                                  % des FIR-Filters
				  
wNewton      = zeros(N, Nstep);   % Initialisierung
wNewton(:,1) = w_start;           % Startwert

for nn=1:Nstep-1;                 % Iterationsloop
  Gradient          = 2*(R*wNewton(:,nn) - p);
                                  % Gradientenberechnung
  wNewton(:,nn+1)   = wNewton(:,nn) - cNewton * inv(2*R) * Gradient;
                                  % Aufdatierung der Filterkoeffizienten
end;

