%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulationen  
%         
%         [E,W,w,inv_R]=rls(N,X,D,w_start,rho)
%
%         RLS-Algorithmus
%
%         E       = Fehlersignal E[.]
%         W       = Filterkoeffizienten im zeitlichen Verlauf
%         w       = Filterkoeffizienten am Ende der Adaption
%         inv_R   = Inverse deterministische Korrelationsmatrix
%		    nach Adaptionsende
%         N       = Anz. Filterkoeffizienten = Filterordnung+1
%         X       = Filtereingang X[.]
%         D       = erwuenschtes Signal D[.]
%         w_start = Startwerte Filterkoeffizienten 
%         rho     = Vergessensfaktor
%
%-------------------------------------------------------------------

%
%	  author:  Markus Hofbauer
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  rls.m
%
% Startfile:  simX.m
%
%-------------------------------------------------------------------
%===================================================================

function [E,W,w,inv_R]=rls(N,X,D,w_start,rho)

p0=1000000;            % Initialisierung von
inv_R=p0*eye(N);       % inv_R 

adaptlen=length(X);
w= w_start;          
W=zeros(N,adaptlen);
E=zeros(adaptlen,1); 

%-------------------------------------------------------------------
% RLS Update Loop
%-------------------------------------------------------------------

for i=N:adaptlen

   W(:,i)=w;
 
   x      = X(i:-1:i-N+1); % Eingangsvektor (x[k],x[k-1],..,x[k-N+1])
   y=x'*w;                 % Filterausgang
   e=D(i)-y;               % Fehler
  
   c=1/(rho+x'*inv_R*x);                
   inv_R=1/rho*(inv_R-c*inv_R*x*x'*inv_R);  % Aufdatierung von inv_R 
   w=w+inv_R*e*x;                           % Aufdatierung von w 

   E(i)=e;
end;


 