%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulationen  
%         
%         [E,W,w,inv_R]=rls_showR(N,X,D,w_start,rho,flag_show_R)
%
%
%         RLS-Algorithmus mit der Option R graphisch darzustellen
%
%         E       = Fehlersignal E[.]
%         W       = Filterkoeffizienten im zeitlichen Verlauf
%         w       = Filterkoeffizienten am Ende der Adaption
%         inv_R   = Inverse deterministische Korrelationsmatrix
%		    nach Adaptionsende
%         N       = Anz. Filterkoeffizienten = Filterordnung+1
%         X       = Filtereingang X[.]
%         D       = erwuenschtes Signal D[.]
%         w_start = Startwerte Filterkoeffizienten 
%         rho     = Vergessensfaktor
%         flag_show_R  =  (= 1) : Darstellung von R
%
%-------------------------------------------------------------------

%
%	  author:  Markus Hofbauer
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  rls_showR.m
%
% Startfile:  simX.m
%
%-------------------------------------------------------------------
%===================================================================




function [E,W,w,inv_R,calc]=rls_showR(N,X,D,w_start,rho,flag_show_R)


%===================================================================
% Initialisierungen
%===================================================================

p0=1000000;            % Initialisierung von
inv_R=p0*eye(N);       % inv_R 

adaptlen=length(X);
w= w_start;           
W=zeros(N,adaptlen);
E=zeros(adaptlen,1); 
power=var(X);

% gobale flags
global stop_flag;
global pause_flag;
global contin_flag;
contin_flag=0;
pause_flag=1;

%===================================================================
% RLS Algorithmus mit Darstellung von R
%===================================================================

if flag_show_R==1         %   Darstellung von R ?

%------------------------------------------------------------------- 
% Einrichten des Fensters fuer R mit gui-Funktionen
%------------------------------------------------------------------- 

f5=figure(5);
set(f5,'resize','off','Position',[ 460 360 664 498]);

% gui-buttons

%  Weiter / Stop
hweiter=uicontrol(f5,'Style','pushbutton','Position',[120 45 115 ...
      23],'String','Weiter / Stop','CallBack','contin_flag=1;pause_flag=1;','ForegroundColor',[1 1 0] );   

% Terminierung
hende=uicontrol(f5,'Style','pushbutton','Position',[10 20 100 23],'String','Ende','CallBack','stop_flag=1;pause_flag=1;','ForegroundColor',[1 1 ...
      0] );  

% Weiter ohne Stop
hnostop=uicontrol(f5,'Style','pushbutton','Position',[120 20 115 23], 'String','Weiter ohne Stop','CallBack','pause_flag=0;contin_flag=1;','ForegroundColor',[1 1 0] );  

% Iterationzaehler
hiter=uicontrol(f5,'Style','text','Position',[12 45 96 ...
      23],'string',['Iteration: ',num2str(1)],'ForegroundColor',[1 0 0]);
 
% erster Plot von R
figure(f5)
R=inv(inv_R);
hh=mesh(R); 
axis([0 N 0 N -1.0*power +1.5*power ])
set(f5,'backingstore','off')
set(get(f5,'currentaxes'),'drawmode','fast');
set(gca,'nextplot','replacechildren')
grid
title('Deterministische Autokorrelationsmatrix (normiert durch 1/k)')


%-------------------------------------------------------------------
% RLS Update Loop
%-------------------------------------------------------------------

for i=N:adaptlen     % (RLS Update Loop)

   W(:,i)=w;
 
   x      = X(i:-1:i-N+1); % Eingangsvektor (x[k],x[k-1],..,x[k-N+1])
   y=x'*w;                 % Filterausgang
   e=D(i)-y;               % Fehler 
  
   c=1/(rho+x'*inv_R*x);                
   inv_R=1/rho*(inv_R-c*inv_R*x*x'*inv_R);    % Aufdatierung von inv_R 
   w=w+inv_R*e*x;                             % Aufdatierung von w 

   E(i)=e;
 
   % Weiter, Pause, Abbruch ?
   pause(0);
   if pause_flag==0 
      % Weiter ohne Pause
   else
      while (contin_flag == 0 & stop_flag==0) ; pause(0); end 
      % Pause bis 'Weiter' oder 'Stop' Aufforderung
   end ;
   contin_flag=0;

   if stop_flag==1 ;  busy_flag=0 ; close(f5); return ;  end  % Abbruch ? 

   % plot von R
   R=inv(inv_R)/(i-N+1);
   hh=mesh(R); 
   drawnow
   set(hiter,'String',['Iteration: ',num2str(i-N+1)]);
 
end;               % (RLS Update Loop)


else    %  keine Darstellung von R ?

%===================================================================
% RLS-Algorithmus ohne Darstellung von R
%===================================================================

for i=N:adaptlen    % (RLS Update Loop)

   W(:,i)=w;
 
   x      = X(i:-1:i-N+1);  % Eingangsvektor (x[k],x[k-1],..,x[k-N+1])
   y=x'*w;                  % Filterausgang
   e=D(i)-y;                % Fehler 
  
   c=1/(rho+x'*inv_R*x);                
   inv_R=1/rho*(inv_R-c*inv_R*x*x'*inv_R);  % Aufdatierung von inv_R 
   w=w+inv_R*e*x;                           % Aufdatierung von w 

   E(i)=e;

end;              % (RLS Update Loop)

end;              % (if flag_show_R)

