%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulation Nr. 4a 
%         
%         Funktion:
%         Hauptprogramm
%
%	  author:  Markus Hofbauer, Peter Wellig, Martin Haenggi
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  s4a_calc.m
%
%
% Startfile:  sim4a.m
%
% Hauptfile:  s4a_calc.m
% (wird aufgerufen)
%
% Benoetigte m-Files: im Verzeichnis sim4
%
%-------------------------------------------------------------------
%===================================================================




%===================================================================
% Vorbereitungen
%===================================================================

pause(0);                                 
set(htmess,'String',message_sim_lau_vor);  % message 
        
    % Hinweis: pause(0) wird jeweils eingesetzt, damit der 
    %          nachfolgende Befehl augenblicklich ausgefuehrt wird
    					   
%-------------------------------------------------------------------
% Lesen der Eingabeparameter und Zuweisung
%------------------------------------------------------------------- 

p1=str2num(get(h1,'string'));
p2=str2num(get(h2,'string'));
p3=str2num(get(h3,'string'));
p4=str2num(get(h4,'string'));
p5=str2num(get(h5,'string'));

% Test auf Gueltigkeit der Eingabe

error_flag=0;
if p1<0  | p2>10 | p3 < 1 | p4 < 0 | p5< 0 
 set(htmess,'String',message_err); error_flag=1;
elseif length(p1) > 1 | length(p2) > 1 | length(p3) > 1 | length(p4) > 1 | ...
      length(p5) > 1 
 set(htmess,'String',message_err); error_flag=1;
else
% Zuweisung
ac=min(p1,99.999); set(h1,'string',num2str(ac))
sigma2Xcos=ac/(100-ac);
sigma2N=10^(p2/10); 
sn2=sigma2N;
loops=p3;
mu=p4;
mu_N=p5;

%------------------------------------------------------------------- 
%  Initialisierungen und Definitionen
%------------------------------------------------------------------- 

N            =   2;         % Anz. Filterkoeffizienten

% Signallaengen
len1   = 600;                      % Laenge der Signale
len2   = len1-N+1;                 % Plotlaenge 
len3   = 200 ; %round(len2/2);     % Mittelungslaenge fuer Jinf

% Parameter Eingangssignal
sigma2Xnoise =   1;              % Varianz von x[.]: Rauschanteil
alphaXcos    = 2*pi/10;          % Normierte Frequenz des Cosinus

b = [0.15 -1.0]; a = [1];        % Filterkoeffizienten des Systems
N_stat= 4096/2;                  % Parameter fuer calc_x.m


mu_N         =   0.05;      % Schrittweite Newton_LMS
Nstep        =   350;       % Anzahl Schritte fuer Newton-/Grad.-Verfahren
cNewton      =   0.03;      % Schrittweite Newton-Verfahren
cGrad        =   0.03;      % Schrittweite Grad.-Verfahren
rho          =   1;         % RLS-Vergessensfaktor  

w2_range    =  -1.5:0.025:0.1;  % Bereich der Filterkoeffizienten fuer 
w1_range    = -1.1:0.025:0.5;   % die Fehlerflaechendarstellung 

WW   = zeros(N,len2);
Kond = zeros(1,loops);
w_start = zeros(N,1);           % Startwerte Filterkoeffizienten 
e2 = zeros(len2,loops) ;        % Fehlerquadrat LMS
e2_N=zeros(len2,loops) ;        % Fehlerquadrat Newton-LMS
e2_RLS=zeros(len2,loops) ;      % Fehlerquadrat RLS

format compact;


% Statistik des Eingangssignals
[R,rx]=calc_R(sigma2Xnoise,sigma2Xcos,alphaXcos,N,N_stat);
invR=inv(R);

end;

% flags
busy_flag=1;
pause_flag=1;
termin_flag=0; 
stop_flag=0;
konv_flag=1;        

%===================================================================
% Loop 
%===================================================================

if error_flag==0;             % falls gueltige Eingabe start loop

for i=1:loops                 % Loop ueber Realisationen


 pause(0); 
 if stop_flag==1  stop_b ; return ; end   % stop ? 
 set(htmess,'String',message_sim_lau);    % message
 set(hta3,'String',num2str(i));           % message

%-------------------------------------------------------------------
% Generierung der Signale
%-------------------------------------------------------------------
 
 [x,d,ws,normx]=signal(len1,sigma2Xnoise,sigma2Xcos,alphaXcos,sigma2N,b,a); 
   % x: Eingangssignal
   % d: erwuenschtes Signal
   % ws: Systemstossantwort
   
%-------------------------------------------------------------------
% Aufruf LMS - Algorithmus
%-------------------------------------------------------------------

 pause(0); 
 set(htmess,'String',message_sim_lau_lms);  % message

 [e,W,w]=lms(mu,N,x,d,w_start);             % LMS-Algorithmus
   % e: Fehlersignal
   % W: Matrix aller Filtergewichte 
   % w: Gewichtsvektor nach Adaptionsende
   
 e2(:,i)=e(N:len1).*e(N:len1);              % Fehlerquadrat
 WW=WW+W(:,1:len2);                 % Addition Filterkoeffizienten

%-------------------------------------------------------------------
% Aufruf Newton-LMS-Algorithmus
%-------------------------------------------------------------------

 pause(0); 
 set(htmess,'String',message_sim_lau_new_lms);  % message
 
 [e_N,WN,wn]=lms_newton(mu_N,N,x,d,w_start,invR);   
 e2_N(:,i)=e_N(N:len1).*e_N(N:len1);         % Fehlerquadrat
 
%-------------------------------------------------------------------
%  Aufruf RLS - Algorithmus
%-------------------------------------------------------------------

 pause(0); 
 set(htmess,'String',message_sim_lau_rls);   % message
 
 [e_RLS,W_RLS,w_rls,inv_R]=rls(N,x,d,w_start,rho);  
   % e_RLS: Fehlersignal
   % W_RLS: Matrix aller Filtergewichte 
   % w_rls: Gewichtsvektor nach Adaptionsende
   
 e2_RLS(:,i)=e_RLS(N:len1).*e_RLS(N:len1);   % Fehlerquadrat

end;  % end loop

%===================================================================
% Auswertung
%===================================================================

pause(0); 
set(htmess,'String',message_sim_lau_ausw); % message
 

J=mean(e2',1);           % Ensemblemittelwert des quadr. Fehlers -> Lernkurve
J_RLS=mean(e2_RLS',1);   % Ensamblemittelwert des quadr. Fehlers -> Lernkurve
J_N=mean(e2_N',1);       % Ensamblemittelwert des quadr. Fehlers -> Lernkurve
			 
WW=WW/loops;             % Ensemblemittelwert der Koeffizienten Mittelwert der Koeffizienten

%-------------------------------------------------------------------
% Berechnung der Statistik und der Wienerloesung
%-------------------------------------------------------------------

pause(0);
if stop_flag==1  stop_b ; return ; end   % stop ?


ryx=calc_ryx(ws,1,rx,N_stat);
p=ryx(1:N)';                      % p: Kreuzkorrelationsvektor

ry=calc_ry(ws,1,rx,N_stat);       % ry:  Autokorr. Funktion von d'
sd2=ry(1)+sigma2N;                % sd2: Varianz von d

% Wienerloesung
w0       = inv(R) * p;

% Jmin
Jmin     = abs(sd2 - p'*w0);

% Konditionszahl
Kond     = cond(R);

%-------------------------------------------------------------------
% Newton-/Gradientenverfahren
%-------------------------------------------------------------------
pause(0);
if stop_flag==1  stop_b ; return ; end     % stop ?

% Newtonverfahren
wNewton  = newton(p, R, w_start, cNewton, Nstep);
w1Newton = wNewton(1,:);
w2Newton = wNewton(2,:);

% Gradientenverfahren
wGrad    = grad(p, R, w_start, cGrad, Nstep);
w1Grad   = wGrad(1,:);
w2Grad   = wGrad(2,:);

%-------------------------------------------------------------------
% Grenzwerte der Lernkurven
%-------------------------------------------------------------------

pause(0);
if stop_flag==1  stop_b ; return ; end  

% Abschaetzung von J[ke], LMS
Jinf=mean(J(len2-len3:len2));       
if Jinf>10*sd2 | isnan(Jinf)        % keine Konvergenz, Schrittweite 
  konv_flag=0;                      % mu zu gross !
  Jinf=sd2;
end

% Abschaetzung  von J[ke], RLS
Jinf2=mean(J_RLS(len2-len3:len2));   

% Abschaetzung  von J[ke], Newton-LMS
Jinf3=mean(J_N(len2-len3:len2));  

% Plotparameter 
if Jinf <= Jmin   Jinf=Jmin* 1.00000001 ; end
if Jinf2 <= Jmin  Jinf2=Jmin*1.00000001 ; end
if Jinf3 <= Jmin  Jinf3=Jmin*1.00000001 ; end
if sn2==0 sn2db='-\infty';  else sn2db=10*log10(sn2) ; end 
if Jmin==0 Jmindb='-\infty'; else Jmindb=10*log10(Jmin) ; end 

%===================================================================
% Graphik
%===================================================================

pause(0);  
set(htmess,'String',message_sim_lau_gra);   % message
if stop_flag==1  stop_b ; return ; end      % stop ?

%-------------------------------------------------------------------
% Lernkurven
%-------------------------------------------------------------------

% figur(2)

f2=figure(2); clf; 
if first_time set(f2,'position', [365 97 664 843]); end; 

% subplot 1, LMS-Lernkurve 
subplot(311);
  plot(db(J)); grid;  xlabel('k')
  axis([0 len2 db(Jmin/10)  db(sd2*10)]);
  ax1=axis; yrange=ax1(4)-ax1(3);
  title(['LMS: Lernkurve J[k] = E[ e[k]^2 ]   (Schaetzung aus ',num2str(loops),' Realisationen)']);
  plotypos1=max(db(Jmin)+0.06*yrange,db(Jinf));
  plotypos1b=max(db(Jmin)+0.01*yrange,db(Jinf));
  hold on;
  plot(plotypos1b*ones(1,len2),'g');
  plot(db(sd2*ones(1,len2)),'r');
  plot(db(Jmin*ones(1,len2)),'r');
  text(-len2*0.08,ax1(4)+yrange*0.05,'[dB]')
  text(-len2*0.15,plotypos1,'J[k_e]')
  text(-len2*0.15,db(Jmin),'J_{min}')
  text(len2*1.01,plotypos1,[sprintf('%1.1f',10*log10(Jinf)),' dB'])
  text(-len2*0.15,db(sd2),'J[0] = \sigma_d^2')
  text(len2*1.01,db(sd2),[sprintf('%1.1f',10*log10(sd2)),' dB'])
  text(len2*1.01,db(Jmin),[sprintf('%1.1f',10*log10(Jmin)),' dB'])

% subplot 2 Newton LMS Lernkurve 
subplot(312);
  plot(db(J_N)); grid; xlabel('k'); %xlabel(['k            (k_e = ',num2str(len2),')'])
  axis([0 len2 db(Jmin/10)  db(sd2*10)]);
  ax1=axis; yrange=ax1(4)-ax1(3);
  title(['Newton LMS  : Lernkurve J[k] = E[ e[k]^2 ]   (Schaetzung aus ',num2str(loops),' Realisationen)']);
  plotypos3=max(db(Jmin)+0.06*yrange,db(Jinf3));
  plotypos3b=max(db(Jmin)+0.01*yrange,db(Jinf3));
  hold on;
  plot(plotypos3b*ones(1,len2),'g');
  plot(db(sd2*ones(1,len2)),'r');
  plot(db(Jmin*ones(1,len2)),'r');
  text(-len2*0.08,ax1(4)+yrange*0.05,'[dB]')
  text(-len2*0.15,plotypos3,'J[k_e]')
  text(-len2*0.15,db(Jmin),'J_{min}')
  text(len2*1.01,plotypos3,[sprintf('%1.1f',10*log10(Jinf3)),' dB'])
  text(-len2*0.15,db(sd2),'J[0] = \sigma_d^2')
  text(len2*1.01,db(sd2),[sprintf('%1.1f',10*log10(sd2)),' dB'])
  text(len2*1.01,db(Jmin),[sprintf('%1.1f',10*log10(Jmin)),' dB'])

% subplot 3 RLS-Lernkurve 
subplot(313);
  plot(db(J_RLS)); grid; xlabel('k')
  axis([0 len2 db(Jmin/10)  db(sd2*10)]);
  ax1=axis; yrange=ax1(4)-ax1(3);
  title(['RLS \rho = 1 : Lernkurve J[k] = E[ e[k]^2 ]   (Schaetzung aus ',num2str(loops),' Realisationen)']);
  plotypos2=max(db(Jmin)+0.06*yrange,db(Jinf2));
  plotypos2b=max(db(Jmin)+0.01*yrange,db(Jinf2));
  hold on;
  plot(plotypos2b*ones(1,len2),'g');
  plot(db(sd2*ones(1,len2)),'r');
  plot(db(Jmin*ones(1,len2)),'r');
  text(-len2*0.08,ax1(4)+yrange*0.05,'[dB]')
  text(-len2*0.15,plotypos2,'J[k_e]')
  text(-len2*0.15,db(Jmin),'J_{min}')
  text(len2*1.01,plotypos2,[sprintf('%1.1f',10*log10(Jinf2)),' dB'])
  text(-len2*0.15,db(sd2),'J[0] = \sigma_d^2')
  text(len2*1.01,db(sd2),[sprintf('%1.1f',10*log10(sd2)),' dB'])
  text(len2*1.01,db(Jmin),[sprintf('%1.1f',10*log10(Jmin)),' dB'])
 
 
% Ausgabe der Kennwerte
su=subplot('position',[0.05 0.01 0.9 0.05]);
  set(su,'ytick',NaN); set(su,'xtick',NaN); set(su,'box','on');
  set(su,'color',[0.75 0.75 0.75]);
  text(0.05,0.4,['\sigma_n^2 =  ',sprintf('%1.1f',sn2db),' dB'])
  text(0.4,0.4,['J_{min} (fuer N = ',num2str(N),') =  ',sprintf('%1.1f',Jmindb),' dB'])
  text(0.8,0.4,['J_{ex} = J[k_e] - J_{min}'])

%-------------------------------------------------------------------
% zeitlicher Verlauf der Filterkoeffizienten
%-------------------------------------------------------------------

% figur(3)

f3=figure(3); clf; 
if first_time set(f3,'position', [9 511 548 430]); end;

subplot(311);
  plot(W(:,(N:len1))'); grid;  ylabel('LMS');
  title(['Adaption der Gewichte w_1, w_2']);
  axis([0 len2 -1.5 1.5]);
 
subplot(312);
   plot(WN(:,(N:len1))'); grid ; ylabel('Newton LMS');
   axis([0 len2 -1.5 1.5]);

subplot(313);
   plot(W_RLS(:,(N:len1))'); grid; xlabel('k'); ylabel('RLS');
   axis([0 len2 -1.5 1.5]);
 

pause(0);  
if stop_flag==1  stop_b ; return ; end    % stop ?

%-------------------------------------------------------------------
% Darstellung des Rekursionsverlaufs verschiendenen 
% Adaptionsalgorithmen im Contourplot
%-------------------------------------------------------------------

% figur(4)

pause(0);  
if stop_flag==1  stop_b ; return ; end    % stop ?

f4=figure(4); clf; 
if first_time  set(f4,'position', [609 450 664 498]); end;

%Fehlerlfaeche
Jflaeche = calcJ(sd2, p, R, w1_range, w2_range);

w1LMS = W(1,:);
w2LMS = W(2,:);
w1LMS_N = WN(1,:);
w2LMS_N = WN(2,:);
w1_RLS = W_RLS(1,:);			
w2_RLS = W_RLS(2,:);

ww1LMS = WW(1,:);
ww2LMS = WW(2,:);

% contourplot
contour(w1_range, w2_range, Jflaeche, linspace(Jmin,max(max(Jflaeche)),50))
hold on;

line(w1LMS,   w2LMS,   'color',[0,0,1]);
line(ww1LMS,  ww2LMS,  'color',[0,1,1]);
line(w1Grad,  w2Grad,  'color',[1,0,0]);
line(w1Newton,w2Newton,'color',[0,1,0]);
line(w1LMS_N,  w2LMS_N, 'color',[1,0,1]);
line(w1_RLS,  w2_RLS, 'color',[0,0,0]);

xlabel('W1');
ylabel('W2');

plot(w0(1),w0(2),'x');
hold  off;
axis('equal');
axis([w1_range(1),w1_range(lge(w1_range)),0.8*w2_range(1),w2_range(lge(w2_range))]);
grid;
title('Rekursionsverlauf verschiedener Adaptionsalgorithmen (2D, Contourplot)');
xlabel('w_1');
ylabel('w_2');
legend('LMS','E[LMS]  (Ensemblemittel)','Gradient','Newton','Newton-LMS','RLS',3);


%-------------------------------------------------------------------
% Darstellung des Rekursionsverlaufs der verschiedenen
% Adaptionsalgorithmen auf der Fehlerflaeche
%-------------------------------------------------------------------

% figur(5)

f5=figure(5); clf; 
if first_time  set(f5,'position', [612 11 664 498]); end;
 
mesh(w1_range ,w2_range, Jflaeche);
view(-10,44)

ax = axis;
axis([w1_range(1), w1_range(length(w1_range)), ...
      w2_range(1), w2_range(length(w2_range)), ...
      ax(5), ax(6)]);

hold on;
offset = 0; 0.05;

JLMS     = calcJ(sd2, p, R, W);
JELMS    = calcJ(sd2, p, R, WW);
JNewton  = calcJ(sd2, p, R, wNewton);
JGrad    = calcJ(sd2, p, R, wGrad);
JLMS_N     = calcJ(sd2, p, R, WN);
J_RLS     = calcJ(sd2, p, R, W_RLS);

line(w1LMS,   w2LMS,   JLMS+offset,   'color',[0,0,1],'linewidth',2);
line(ww1LMS,  ww2LMS,  JELMS+offset,  'color',[0,1,1],'linewidth',2);
line(w1Grad,  w2Grad,  JGrad+offset,  'color',[1,0,0],'linewidth',2);
line(w1Newton,w2Newton,JNewton+offset,'color',[0,1,0],'linewidth',2);
line(w1LMS_N,   w2LMS_N,   JLMS_N+offset,   'color',[1,0,1],'linewidth',2);
line(w1_RLS,   w2_RLS,   J_RLS+offset,'color',[0,0,0],'linewidth',2);

xlabel('w_1');
ylabel('w_2');
zlabel('J');
title('Rekursionsverlauf verschiedener Adaptionsalgorithmen (Fehlerflaeche)');
hold off;
legend('LMS','E[LMS]  (Ensemblemittel)','Gradient','Newton','Newton-LMS','RLS',1);


%===================================================================
% I/0 Fenster, Ausgabe 
%===================================================================

set(hta1,'String',num2str(N)); 
set(hta2,'String',num2str(mu));
set(hta4,'String',num2str(Kond));
set(htmess,'String',message_sim_abg); 


first_time=0;

end;   % end (if error_flag==0)

%-------------------------------------------------------------------
% Abschluss
%-------------------------------------------------------------------

busy_flag=0;

if konv_flag==0  set(htmess,'String',message_konv); end;
if termin_flag==1; terminate; end


%============================== end ================================

