%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulation Nr. 4c  
%         
%         Funktion:
%         Hauptprogramm
%
%	  author:  Markus Hofbauer
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  s4c_calc.m
%
%
% Startfile:  sim4c.m
%
% Hauptfile:  s4c_calc.m
% (wird aufgerufen)
%
% Benoetigte m-Files: im Verzeichnis sim4
%
%-------------------------------------------------------------------
%===================================================================




%===================================================================
% Vorbereitungen
%===================================================================

pause(0);                                 
set(htmess,'String',message_sim_lau_vor);  % message 
        
    % Hinweis: pause(0) wird jeweils eingesetzt, damit der 
    %          nachfolgende Befehl augenblicklich ausgefuehrt wird
    					   
%-------------------------------------------------------------------
% Lesen der Eingabeparameter
%---------------------------------------------

p1=str2num(get(h1,'string'));
p2=str2num(get(h2,'string'));
p3=str2num(get(h3,'string'));
p4=str2num(get(h4,'string'));
p5=str2num(get(h5,'string'));
p6=str2num(get(h6,'string'));
pch=get(hchbox,'value');

ac=min(p1,99.999); set(h1,'string',num2str(ac))
sigma2Xcos=ac/(100-ac);
sigma2N=10^(p2/10); 
sn2=sigma2N;
loops=p3;
mu=p4;
N=p5;
rho=p6;
systemchange_flag=pch;

%------------------------------------------------------------------- 
%  Initialisierungen und Definitionen
%------------------------------------------------------------------- 

% flags
busy_flag=1;
pause_flag=1;
termin_flag=0; 
error_flag=0;
stop_flag=0;
konv_flag=1;        

% Signallaengen
len1    = 800;                   % Laenge der Signale
len2   = len1-N+1;               % Plotlaenge 
len3   = 300 ; %round(len2/2);   % Mittelungslaenge fuer Jinf

% Parameter Eingangssignal
sigma2Xnoise =   1;              % Varianz von x[.]: Rauschanteil
alphaXcos    = 2*pi/10;          % Normierte Frequenz des Cosinus


N_stat = 4096/2;                 % Parameter fuer calc_x.m
b = [1]; a = [1 0.7];            % Filterkoeffizienten des Systems

Kond = zeros(1,loops);
e2 = zeros(len2,loops) ;         % Fehlerquadrat LMS
e2_RLS=zeros(len2,loops) ;       % Fehlerquadrat RLS rho=1
e2_RLSrho=zeros(len2,loops) ;    % Fehlerquadrat RLS rho
w_start      = zeros(N,1);       % Startwerte Filterkoeffizienten 


%w1_range    = -0.3:0.05:1.5;   % Bereich der Filterkoeffizienten fuer 
%w2_range    = -0.8:0.05:0.3;   % die Fehlerflaechendarstellung


format compact;


%------------------------------------------------------------------- 
% Test auf Gueltigkeit der Eingabe
%------------------------------------------------------------------- 

if p1<0  | p2>10 | p3 < 1 | p4 < 0 | p5< 1 p6<0 | p6>1
 set(htmess,'String',message_err); error_flag=1;
end 

%===================================================================
% Loop 
%===================================================================

if error_flag==0;             % falls gueltige Eingabe start loop

for i=1:loops                 % Loop ueber Realisationen
   
 pause(0); 
 if stop_flag==1  stop_b ; return ; end   % stop ? 
 set(htmess,'String',message_sim_lau);    % message
 set(hta3,'String',num2str(i));           % message

%-------------------------------------------------------------------
% Generierung der Signale
%-------------------------------------------------------------------
 
  [x,d,ws,norm]=signal_changew(len1,sigma2Xnoise,sigma2Xcos,alphaXcos,sigma2N,b,a,systemchange_flag); 
   % x: Eingangssignal
   % d: erwuenschtes Signal
   % ws: Systemstossantwort
   
  
%-------------------------------------------------------------------
% Aufruf LMS - Algorithmus
%-------------------------------------------------------------------

 pause(0); 
 set(htmess,'String',message_sim_lau_lms);  % message
 pause(0); 
 
 [e,W,w]=lms(mu,N,x,d,w_start);             % LMS-Algorithmus
   % e: Fehlersignal
   % W: Matrix aller Filtergewichte 
   % w: Gewichtsvektor nach Adaptionsende
   
 e2(:,i)=e(N:len1).*e(N:len1);              % Fehlerquadrat

%-------------------------------------------------------------------
%  Aufruf RLS - Algorithmus
%-------------------------------------------------------------------

 pause(0); 
 set(htmess,'String',message_sim_lau_rls);   % message
 pause(0); 
 
% RLS rho=1
[e_RLS,W_RLS,w_RLS,inv_R]=rls(N,x,d,w_start,1); 
% RLS rho
[e_RLSrho,W_RLSrho,w_RLSrho,inv_R]=rls(N,x,d,w_start,rho); 
   % e_RLS: Fehlersignal
   % W_RLS: Matrix aller Filtergewichte 
   % w_rls: Gewichtsvektor nach Adaptionsende
   
e2_RLS(:,i)=e_RLS(N:len1).*e_RLS(N:len1);               % Fehlerquadrat
e2_RLSrho(:,i)=e_RLSrho(N:len1).*e_RLSrho(N:len1);      % Fehlerquadrat

end;  % end loop

%===================================================================
% Auswertung
%===================================================================

pause(0); 
set(htmess,'String',message_sim_lau_ausw); % message
 
J=mean(e2',1);         % Ensemblemittelwert des quadr. Fehlers -> Lernkurve
J_RLS=mean(e2_RLS',1);            
J_RLSrho=mean(e2_RLSrho',1);    

%-------------------------------------------------------------------
% Berechnung der Statistik und der Wienerloesung
%-------------------------------------------------------------------

pause(0);
if stop_flag==1  stop_b ; return ; end   % stop ?

[R,rx]=calc_R(sigma2Xnoise,sigma2Xcos,alphaXcos,N,N_stat); 
                      % R: Autokorr. Matrix; rx: Autokorr. Funktion
ryx=calc_ryx(ws,1,rx,N_stat);
p=ryx(1:N)';                            % p: Kreuzkorrelationsvektor

ry=calc_ry(ws,1,rx,N_stat);             % ry:  Autokorr. Funktion von d'
sd2=ry(1)+sigma2N;                      % sd2: Varianz von d

% Wienerloesung
w0       = inv(R) * p;

% Jmin
Jmin     = abs(sd2 - p'*w0);
Kond     = cond(R);


%-------------------------------------------------------------------
% Grenzwerte der Lernkurven, Fehleinstellung
%-------------------------------------------------------------------

% Abschaetzung von J[ke], LMS
Jinf=mean(J(len2-len3:len2));      

if Jinf>10*sd2 | isnan(Jinf)        % keine Konvergenz, Schrittweite 
  konv_flag=0;                      % mu zu gross !
  Jinf=sd2;
end

% Abschaetzung  von J[ke], RLS rho=1
Jinf2=mean(J_RLS(len2-len3:len2));     

% Abschaetzung  von J[ke], RLS rho
Jinf3=mean(J_RLSrho(len2-len3:len2));  


% Fehleinstellung LMS
M=(Jinf-Jmin)/Jmin;
if M > 10 Mplot=[' > 1000 %'] ; else  Mplot=[sprintf('%1.1f',100*M),'%']; end;

% Fehleinstellung RLS rho=1
M2=(Jinf2-Jmin)/Jmin;
if M2 > 20 M2plot=[' > 1000 %'] ; else  M2plot=[sprintf('%1.1f',100*M2),'%']; end;

% Fehleinstellung RLS rho
M3=(Jinf3-Jmin)/Jmin;
if M3 > 10 M3plot=[' > 1000 %'] ; else  M3plot=[sprintf('%1.1f',100*M3),'%']; end;

% Plotparameter 
if Jinf <= Jmin   Jinf=Jmin* 1.00000001 ; end
if Jinf2 <= Jmin  Jinf2=Jmin*1.00000001 ; end
if Jinf3 <= Jmin  Jinf3=Jmin*1.00000001 ; end
if sn2==0 sn2db='-\infty';  else sn2db=10*log10(sn2) ; end 
if Jmin==0 Jmindb='-\infty'; else Jmindb=10*log10(Jmin) ; end 

%-------------------------------------------------------------------
% Berechnung des Systemfehlermasses
%-------------------------------------------------------------------

dw0=ws- [w0;zeros(length(ws)-N,1)];
dw=ws- [w;zeros(length(ws)-N,1)];
dw_RLS=ws- [w_RLS;zeros(length(ws)-N,1)];
dw_RLSrho=ws- [w_RLSrho;zeros(length(ws)-N,1)];

dw0_db=db(sum(dw0.^2)/sum(ws.^2));
dw1_db=db(sum(dw.^2)/sum(ws.^2));
dw2_db=db(sum(dw_RLS.^2)/sum(ws.^2));
dw3_db=db(sum(dw_RLSrho.^2)/sum(ws.^2));


%===================================================================
% Graphik
%===================================================================

pause(0);  
set(htmess,'String',message_sim_lau_gra);   % message
if stop_flag==1  stop_b ; return ; end      % stop ?

%-------------------------------------------------------------------
% Lernkurven
%-------------------------------------------------------------------

% figur(2)

f2=figure(2); clf; 
if first_time set(f2,'position', [587 44 683 897]); end;

% subplot 1, LMS-Lernkurve  
subplot(311);
  plot(db(J)); grid;  xlabel('k')
  axis([0 len2 db(Jmin/10)  db(sd2*10)]);
  ax1=axis; yrange=ax1(4)-ax1(3);
  title(['LMS: Lernkurve J[k] = E[ e[k]^2 ]   (Schaetzung aus ',num2str(loops),' Realisationen)']);
  plotypos1=max(db(Jmin)+0.06*yrange,db(Jinf));
  plotypos1b=max(db(Jmin)+0.01*yrange,db(Jinf));
  hold on;
  plot(plotypos1b*ones(1,len2),'g');
  plot(db(sd2*ones(1,len2)),'r');
  plot(db(Jmin*ones(1,len2)),'r');
  text(-len2*0.08,ax1(4)+yrange*0.05,'[dB]')
  text(-len2*0.15,plotypos1,'J[k_e]')
  text(-len2*0.15,db(Jmin),'J_{min}')
  text(len2*1.01,plotypos1,[sprintf('%1.1f',10*log10(Jinf)),' dB'])
  text(-len2*0.15,db(sd2),'J[0] = \sigma_d^2')
  text(len2*1.01,db(sd2),[sprintf('%1.1f',10*log10(sd2)),' dB'])
  text(len2*1.01,db(Jmin),[sprintf('%1.1f',10*log10(Jmin)),' dB'])

% subplot 2 RLS-Lernkurve rho=1 
subplot(312);
  plot(db(J_RLS)); grid; xlabel('k')
  axis([0 len2 db(Jmin/10)  db(sd2*10)]);
  ax1=axis; yrange=ax1(4)-ax1(3);
  title(['RLS \rho = 1 : Lernkurve J[k] = E[ e[k]^2 ]   (Schaetzung aus ',num2str(loops),' Realisationen)']);
  plotypos2=max(db(Jmin)+0.06*yrange,db(Jinf2));
  plotypos2b=max(db(Jmin)+0.01*yrange,db(Jinf2));
  hold on;
  plot(plotypos2b*ones(1,len2),'g');
  plot(db(sd2*ones(1,len2)),'r');
  plot(db(Jmin*ones(1,len2)),'r');
  text(-len2*0.08,ax1(4)+yrange*0.05,'[dB]')
  text(-len2*0.15,plotypos2,'J[k_e]')
  text(-len2*0.15,db(Jmin),'J_{min}')
  text(len2*1.01,plotypos2,[sprintf('%1.1f',10*log10(Jinf2)),' dB'])
  text(-len2*0.15,db(sd2),'J[0] = \sigma_d^2')
  text(len2*1.01,db(sd2),[sprintf('%1.1f',10*log10(sd2)),' dB'])
  text(len2*1.01,db(Jmin),[sprintf('%1.1f',10*log10(Jmin)),' dB'])
 
% subplot 2 RLS-Lernkurve rho 
subplot(313);
  plot(db(J_RLSrho)); grid; xlabel('k'); %xlabel(['k            (k_e = ',num2str(len2),')'])
  axis([0 len2 db(Jmin/10)  db(sd2*10)]);
  ax1=axis; yrange=ax1(4)-ax1(3);
  title(['RLS \rho = ',num2str(rho),' : Lernkurve J[k] = E[ e[k]^2 ]   (Schaetzung aus ',num2str(loops),' Realisationen)']);
  plotypos3=max(db(Jmin)+0.06*yrange,db(Jinf3));
  plotypos3b=max(db(Jmin)+0.01*yrange,db(Jinf3));
  hold on;
  plot(plotypos3b*ones(1,len2),'g');
  plot(db(sd2*ones(1,len2)),'r');
  plot(db(Jmin*ones(1,len2)),'r');
  text(-len2*0.08,ax1(4)+yrange*0.05,'[dB]')
  text(-len2*0.15,plotypos3,'J[k_e]')
  text(-len2*0.15,db(Jmin),'J_{min}')
  text(len2*1.01,plotypos3,[sprintf('%1.1f',10*log10(Jinf3)),' dB'])
  text(-len2*0.15,db(sd2),'J[0] = \sigma_d^2')
  text(len2*1.01,db(sd2),[sprintf('%1.1f',10*log10(sd2)),' dB'])
  text(len2*1.01,db(Jmin),[sprintf('%1.1f',10*log10(Jmin)),' dB'])


% Ausgabe der Kennwerte 
su=subplot('position',[0.05 0.005 0.9 0.06]);
  set(su,'ytick',NaN); set(su,'xtick',NaN); set(su,'box','on');
  set(su,'color',[0.75 0.75 0.75]);
  text(0.02,0.6,['\sigma_n^2 =  ',sprintf('%1.1f',sn2db),' dB'])
  text(0.4,0.6,['J_{min} (fuer N = ',num2str(N),') =  ',sprintf('%1.1f',Jmindb),' dB'])
  text(0.75,0.6,['J_{ex} = J[k_e] - J_{min}'])
  text(0.02,0.2,['M_{LMS} = J_{ex}/J_{min} :  ',Mplot])
  text(0.4,0.2,['M_{RLS} = J_{ex}/J_{min} :  ',M2plot])
  text(0.75,0.2,['M_{RLS\rho} = J_{ex}/J_{min} :  ',M3plot])



%-------------------------------------------------------------------
% zeitlicher Verlauf der Filterkoeffizienten
%-------------------------------------------------------------------

% figur(3)

f3=figure(3); clf; 
if first_time set(f3,'position', [ 8 502 568 437 ]);  end;

subplot(211);
  plot((W_RLS(:,N:len1))'); grid; xlabel('k'); ylabel('w');
  title(['RLS , \rho = 1  :    Adaption der ',num2str(N),' Gewichte']);

subplot(212);
  plot((W_RLSrho(:,N:len1))'); grid; xlabel('k'); ylabel('w');
  title(['RLS \rho = ',num2str(rho),'  :    Adaption der ',num2str(N),' Gewichte']);

pause(0);  
if stop_flag==1  stop_b ; return ; end    % stop ?

%-------------------------------------------------------------------
% Vergleich der Filtergewichte mit der Systemantwort
%-------------------------------------------------------------------

f4=figure(4); clf; 
if first_time set(f4,'position', [371 7 664 720]); end;

% subplot 1, Vergleich mit der Systemantwort 
subplot(211)
  axis([1 lge(ws) 1.2*min([ws;w]) 1.2*max([ws;w])])
  ax=axis;
  yrange1=(ax(4)-ax(3)) ;
  patch([ax(1) ax(1) N N ax(1)],[ax(3) ax(4) ax(4) ax(3) ax(3)],[0.9 0.9 0.9])
  hold on;
  plot(ws,'b')
  plot(w0,'g')
  plot(w,'r')
  plot(w_RLS,'m')
  plot(ws,'b')
  line([N N+4],(ax(4)-0.1*yrange1)*[1 1]); text(N+5,(ax(4)-0.1*yrange1),'identifizierter')
  text(N+5,(ax(4)-0.2*yrange1),'Teil')
  title('Vergleich der Filter mit der Systemantwort')
  xlabel('Index Koeffizienten ')
  ylabel('w')
  legend('System','Wienerloesung','LMS','RLS',4)


% subplot 2, Abweichung von der Systemantwort 
su=subplot(212) ;
  ps=get(su,'position'); set(su,'position',[ps(1) 1.4*ps(2) ps(3) ps(4)]);
  dw1=ws- [w0;zeros(length(ws)-N,1)];
  dw2=ws- [w;zeros(length(ws)-N,1)];
  dw3=ws- [w_RLS;zeros(length(ws)-N,1)];
  dw4=ws- [w_RLSrho;zeros(length(ws)-N,1)];
  axis([1 lge(ws) 1.2*min([dw2;dw3]) 1.2*max([dw2;dw3])])
  ax=axis;
  patch([ax(1) ax(1) N N ax(1)],[ax(3) ax(4) ax(4) ax(3) ax(3)],[0.9 0.9 0.9])
  hold on;
  plot(dw1,'g')
  plot(dw2,'r')
  plot(dw3,'m')
  plot(dw4,'k')
  plot(dw1,'g')
  title('Abweichung der Filter von der Systemantwort')
  xlabel('Index Koeffizienten ')
  ylabel('\Delta w')
  legend('Wienerloesung','LMS','RLS','RLS \rho',4)

  
 % Ausgabe des System-Fehler-Masses
su=subplot('position',[0.05 0.01 0.9 0.08]);
  set(su,'ytick',NaN); set(su,'xtick',NaN); set(su,'box','on');
  set(su,'color',[0.75 0.75 0.75]);
  text(0.02,0.5,'System-Fehler-Mass:')
  text(0.35,0.65,['\Deltaw_{dB (Wiener)} = ',sprintf('%1.1f',dw0_db),' dB']);
  text(0.7,0.65,['\Deltaw_{dB (LMS)}   = ',sprintf('%1.1f',dw1_db),' dB']);
  text(0.35,0.15,['\Deltaw_{dB (RLS)}   = ',sprintf('%1.1f',dw2_db),' dB']);
  text(0.7,0.15,['\Deltaw_{dB (RLS \rho)}   = ',sprintf('%1.1f',dw3_db),' dB']);


%===================================================================
% I/0 Fenster, Ausgabe 
%===================================================================

set(hta1,'String',num2str(N)); 
set(hta2,'String',num2str(mu));
set(hta4,'String',num2str(Kond));
set(htmess,'String',message_sim_abg); 


first_time=0;

end;   % end (if error_flag==0)

%-------------------------------------------------------------------
% Abschluss
%-------------------------------------------------------------------

busy_flag=0;

if konv_flag==0  set(htmess,'String',message_konv); end;
if termin_flag==1; terminate; end


%============================== end ================================
 
  
  
  
  
  
  




