%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulationen  
%         
%         [X,D,ws,norm]=signal(len,sigma2X,sigma2Xcos,alphaXcos,sigma2N,b,a)
%
%         Erzeugung der Signale X,D
%         Eingangssignal: x = cos + weisses Rauschen
%         erwuenschtes Signal d = Systemausgang + Messrauschen
%
%         X          = Filtereingang X[.]
%         D          = erwuenschtes Signal D[.]
%         ws         = Systemstossantwort (gegeben durch b,a)
%         norm       = Normierung des Systemfilters (s.u.)
%         len        = Signallaenge
%         sigma2X    = Varianz  weisses Rauschen          
%         sigma2Xcos = Varianz cos
%         alphaXcos  = Normierte Frequenz cos
%         sigma2N    = Varianz weisses Messrauschen
%         b,a        = Filterkoeffizienten des Systemfilters
%

%-------------------------------------------------------------------

%
%	  author:  Markus Hofbauer, Peter Wellig, Martin Haenggi,
%                  Pascal Vontobel, Dieter Arnold
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  signal.m
%
% Startfile:  simX.m
%
%-------------------------------------------------------------------
%===================================================================

function [X,D,ws,norm]=signal(len,sigma2X,sigma2Xcos,alphaXcos,sigma2N,b,a)

% Eingangssignal x 
X = sqrt(sigma2X)*randn(len,1) ...
    + sqrt(2*sigma2Xcos)*cos(alphaXcos*(0:1:len-1)' + 2*pi*rand(1));    
                       % Eingangssignal x = cos + weisses Rauschen
		       
normX=sqrt(var(X));    % Normierung der Eingangsleistung auf var(X)=1
X=X/normX;    

% Systemausgang Ys 
Ys = filter(b,a,X);    % Systemausgang Ys            
normYs=sqrt(var(Ys));  % Normierung des Systemausgangs auf var(Ys)=1 (*)
Ys=Ys/normYs;

% weisses Messrauschen 
N = sqrt(sigma2N)*randn(len,1);      

% erwuenschtes Signal d 
D = Ys+N;              % d = Systemausgang + Messrauschen

% Systemstossantwort ws
ntaps = 50;                   % Laenge der Systemstossantwort 
norm=1/normYs;         
dirac=[1 zeros(1,ntaps-1)];   % Dirac-Stoss
ws=filter(b,a,dirac)'* norm;  % Filterung mit Dirac-Stoss
                              % und Normierung mit norm
			      % damit var(Ys)=1, siehe (*)

