%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulationen  
%         
%         [X,D,ws,norm]=signal_changew(len,sigma2X,sigma2Xcos,alphaXcos,sigma2N,b,a,systemchange_flag)
%
%         Erzeugung der Signale X,D, Option einer Systemaenderung ws -> -ws
%         bei T/4.
%
%         Eingangssignal: x = cos + weisses Rauschen
%         erwuenschtes Signal d = Systemausgang + Messrauschen
%
%         X          = Filtereingang X[.]
%         D          = erwuenschtes Signal D[.]
%         ws         = Systemstossantwort (gegeben durch b,a)
%         norm       = Normierung des Systemfilters (s.u.)
%         len        = Signallaenge
%         sigma2X    = Varianz  weisses Rauschen          
%         sigma2Xcos = Varianz cos
%         alphaXcos  = Normierte Frequenz cos
%         sigma2N    = Varianz weisses Messrauschen
%         b,a        = Filterkoeffizienten des Systemfilters
%         systemchange_flag (= 1:) Systemaenderung ws -> -ws bei T/4 

%-------------------------------------------------------------------

%
%	  author:  Markus Hofbauer
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  signal_changew.m
%
% Startfile:  simX.m
%
%-------------------------------------------------------------------
%===================================================================

 
function [X,D,ws,norm]=signal_changew(len,sigma2X,sigma2Xcos,alphaXcos,sigma2N,b,a,systemchange_flag)

% Eingangssignal x 
X = sqrt(sigma2X)*randn(len,1) ...
    + sqrt(2*sigma2Xcos)*cos(alphaXcos*(0:1:len-1)' + 2*pi*rand(1));    
              % Eingangssignal x = cos + weisses Rauschen

normX=sqrt(var(X)); % Normierung der Eingangsleistung auf var(X)=1
X=X/normX;    
	      
% Systemausgang Ys 
if systemchange_flag==1        %  Systemaenderung ws -> -ws bei T/4 ?
  y1= filter(b,a,X(1:ceil(len/4)));         % Systemausgang Ys mit  ws      
  b=-b;                                     % ws -> -ws 
  y2= filter(b,a,X(ceil(len/4)+1:len));     % Systemausgang Ys mit -ws 
  Ys=[y1;y2];
else  
  Ys = filter(b,a,X);                       % Systemausgang Ys mit  ws         
end
normYs=sqrt(var(Ys));  % Normierung des Systemausgangs auf var(Ys)=1 (*)
Ys=Ys/normYs;

% weisses Messrauschen 
N = sqrt(sigma2N)*randn(len,1);      

% erwuenschtes Signal d 
D = Ys+N;              % d = Systemausgang + Messrauschen

% Systemstossantwort ws
ntaps = 50;                   % Laenge der Systemstossantwort 
norm=1/normYs;         
dirac=[1 zeros(1,ntaps-1)];   % Dirac-Stoss
ws=filter(b,a,dirac)'* norm;  % Filterung mit Dirac-Stoss
                              % und Normierung mit norm
			      % damit var(Ys)=1, siehe (*)
			      
			      
	
