%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulationen  
%         
%         function [ry]=calc_ryb(b,a,rx,N_stat);
%
%         Berechnung der Autokorrelationsfunktion ry des Ausgangs
%         eines Filters. Wie calc_ry.m, jedoch Berechnung der Faltung
%         im Frequenzbereich. 
%         
%
%              x: Eingang, y: Ausgang des Filters mit den
%              Koeffizienten b,a

%              ry: Autokorrelationsfunktion y
%              rx: Autokorrelationsfunktion x
%              N_stat: Faltungslaenge. Je laenger rx oder 
%              die Systemstossantwort, desto groesser muss N_stat 
%              sein, um eine gleiche Genauigkeit zu erreichen.
%
%              Berechnung: ry[.] = h[.] * h[-.] * rx
%                          h: Systemstossantwort
%
%-------------------------------------------------------------------

%
%	  author:  Markus Hofbauer,
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  calc_ryb.m
%
% Startfile:  simX.m
%
%-------------------------------------------------------------------
%===================================================================

function [ry]=calc_ryb(b,a,rx,N_stat);

N_stat= 2^ceil(log2(N_stat)); 

% Autokorrelationsfunktion von x 
rx1=[rx zeros(1,N_stat-lge(rx))];                 % einseitig
rx2=[zeros(1,2*N_stat+1) rx1(lge(rx1):-1:2) rx1]; % zweiseitige Ergaenzung
                                                  % und Verschiebung nach 
						  % Rechts -> lineare Faltung

% Systemuebertragungsfunktion
H=(fft(b,4*N_stat)./fft(a,4*N_stat));

% Leistungsdichtesprektrum von y  
Ry=abs(H).^2.*fft(rx2,4*N_stat);        % Ry = |H|^2  Rx
% Autokorrelationsfunktion von y  
ry=real(ifft(Ry));
ry=[ry(3*N_stat+1:4*N_stat)];  % Nullpunkt bei ry[1]
 
  
 
