%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulationen  
%         
%         function [ryx]=calc_ryxb(b,a,rx,N_stat);
%
%         Berechnung der Kreuzkorrelationsfunktion ryx. 
%         Wie calc_ryx.m, jedoch Berechnung der Faltung
%         im Frequenzbereich. 
%
%              x: Eingang, y: Ausgang des Filters mit den
%              Koeffizienten b,a

%              ryx:Kreuzkorrelationsfunktion
%              rx: Autokorrelationsfunktion
%              N_stat: Faltungslaenge. Je laenger rx oder 
%              die Systemstossantwort, desto groesser muss N_stat 
%              sein, um eine gleiche Genauigkeit zu erreichen.
%
%              Berechnung: ryx[.] = h[.] * rx
%                          h: Systemstossantwort
%
%-------------------------------------------------------------------

%
%	  author:  Markus Hofbauer,
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  calc_ryxb.m
%
% Startfile:  simX.m
%
%-------------------------------------------------------------------
%===================================================================

function [ryx]=calc_ryxb(b,a,rx,N_stat);

N_stat= 2^ceil(log2(N_stat)); 

% Autokorrelationsfunktion von x 
rx1=[rx zeros(1,N_stat-lge(rx))];                 % einseitig
rx2=[zeros(1,2*N_stat+1) rx1(lge(rx1):-1:2) rx1]; % zweiseitige Ergaenzung
                                                  % und Verschiebung nach 
	                                          % Rechts -> lineare Faltung

% Systemuebertragungsfunktion	  
H=(fft(b,4*N_stat)./fft(a,4*N_stat));
% Kreuzleistungsdichtesprektrum von y und x  
Ryx=H.*fft(rx2,4*N_stat);              % Ryx = H Rx
% Autokorrelationsfunktion von y  
ryx=real(ifft(Ryx));
ryx=[ryx(3*N_stat+1:4*N_stat)];        % Nullpunkt bei ry[1]
 
 
   
 