%-------------------------------------------------------------------
%
%   function func_out=expwin2(func_in,factor);
%      
%        Glaettung (zeitliche Mittelung) der Eingangssequenz  func_in 
%        mit Hilfe eines exponentiellen Fensters. Gleich wie expwin.m, 
%        aber Start bei mean(1:lge(func_in)/100)
%
%        func_in: Eingangssequenz 
%        factor:  Vergessensfaktor (0 < factor < 1) 
%                 je naeher bei 1, desto groesser die Gewichtung des 
%                 neuen Wertes, d.h desto schwaecher die Glaettung
%
%-------------------------------------------------------------------

%
%	  author:  Markus Hofbauer,
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%-------------------------------------------------------------------

function func_out=expwin2(func_in,factor);

func_out=zeros(size(func_in,1),1);
func_out(1)=mean(func_in(1:ceil(length(func_in)/100)));
for i=2:size(func_in),
  func_out(i)=factor*func_in(i) + (1-factor)*func_out(i-1);
end;


