%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulationen  
%         
%         [ee,w,dd,calc,Px]=flms(mu,N,C,L,x,d,w_start)
%
%         FLMS-Algorithmus
%
%         ee      = Fehlersignal 
%         w       = Filterkoeffizienten am Ende der Adaption
%         dd      = Filterausgang, Schaetzung von d
%         calc    = Rechenzeit
%         Px      = Schaetzung des Leistungsdichtespektrums vom x
%         mu      = Schrittweite
%         N       = Anz. Filterkoeffizienten = Filterordnung+1
%         X       = Filtereingang x[.]
%         d       = erwuenschtes Signal d[.]
%         w_start = Startwerte Filterkoeffizienten 
%
%-------------------------------------------------------------------

%
%	  author:  Markus Hofbauer
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  flms.m
%
% Startfile:  sim5.m
%
%-------------------------------------------------------------------
%===================================================================

function [ee,w,dd,calc,PX]=flms(mu,N,C,L,x,d,w_start)

% Initialisierungen

ee=zeros(lge(x),1);     % Fehlervektor
dd=zeros(lge(x),1);     % Filterausgang, Schaetzung von d
WS = zeros(C,1);	% Gewichtsvektor im Frequenzbereich
w  = zeros(C,1);        % Gewichtsvektor im Zeitbereich
PX = C*ones(C,1);	% Schaetzung des  Leistungsdichtespektrums
X  = zeros(C,1);	% Eingangsvektor im Frequenzbereich

%% FLMS Parameter
numblk = floor(lge(x)/L);    % Anzahl Verarbeitungsbloecke
begin=ceil(C/L)-1;           % erster Blockindex
gamma = 0.6;	             % Vergessensfaktor

tic;     % Stopuhr laeuft

%-------------------------------------------------------------------
% FLMS Update Loop
%-------------------------------------------------------------------

for j = begin: numblk-1

  % DFT von x, Laenge C
  X = fft(x((j+1)*L-C+1:(j+1)*L));	% aktuellster Wert
                                        % des Blockes: (j+1)*L		
  % Filterung im Frequenzbereich 
  YS = (X .* WS);		    
  ys = real(ifft(YS));		 % IDFT, Filterausgang im Zeitbereich 

  % Fehlersignal im Zeitbereich
  ee(j*L+1:(j+1)*L) = d(j*L+1:(j+1)*L) - ys(C-L+1:C);
            % Overlap-Save-Verfahren: nur die letzten L Werte von ys 
	    % werden verwendet um eine lineare Faltung zu erhalten

  % Fehlersignal im Frequenzbereich
  E = fft([zeros(C-L,1); ee(j*L+1:(j+1)*L)]);  
  
  % Update von PX  
  PX=abs((1-gamma)*conj(X).*X+ gamma * PX);	

  % Update von WS
  WS = WS + mu * conj(X)./(PX+0.001) .* E ;  % Adaption von WS
    
  % Projektion (letzten L-1 Werte von w zu Null setzten)
  w = real(ifft(WS));               
  WS = fft(w(1:C-L+1),C);           

   
  dd(j*L+1:(j+1)*L) = ys(C-L+1:C);     % Abspeichern der Schaetzung

end; 

calc=toc;                          % Stopuhr angehalten
w = [w(1:C-L+1) ; zeros(L-1,1)];   % Filterkoeffizienten am Ende der Adaption



