%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulationen  
%         
%         [E,W,w,DD,calc]=lms_2(mu, N, X, D, w_start, begin)
%
%         LMS-Algorithmus, 
%         wie lms.m, jedoch:
%                     -  Adaptionstart bei: begin
%                     -  unterbrechbar
%                     -  Rechenzeit wird ausgegeben 
%
%         E        = Fehlersignal E[.]
%         W        = Filterkoeffizienten im zeitlichen Verlauf
%         w        = Filterkoeffizienten am Ende der Adaption
%         DD       = Filterausgang, Schaetzung von D
%         calc     = Rechenzeit
%         mu       = Schrittweite
%         N        = Anz. Filterkoeffizienten = Filterordnung+1
%         X        = Filtereingang X[.]
%         D        = erwuenschtes Signal D[.]
%         w_start  = Startwerte Filterkoeffizienten 
%         begin    = Adaptionstartpunkt
%-------------------------------------------------------------------

%
%	  author:  Markus Hofbauer, Peter Wellig, Martin Haenggi 
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  lms_2.m
%
% Startfile:  simX.m
%
%-------------------------------------------------------------------
%===================================================================

function [E,W,w,DD,calc]=lms_2(mu, N, X, D, w_start,begin)

% Initialisierungen
adaptlen=length(X);
w = w_start; 
W=0;    % eigentlich  zeros(N,adaptlen), hier aber N x adaptlen zu gross      
DD=zeros(adaptlen,1); 
E=zeros(adaptlen,1); 
calc=0;

global stop_flag;
global busy_flag;


tic;      % Stopuhr laeuft

% Loop

for i=begin:adaptlen

% Abbruch ?
if rem(i,300)==0 ; pause(0) ;end               % alle 300 Iterationen pause(0)
if stop_flag==1  ; busy_flag=0 ; return ; end  % damit stop_flag aktualisiert
                                               % wird
					       
% W(:,i) = w;    %  hier N x adaptlen zu gross um  W(:,i) zu speichern  

  x      = X(i:-1:i-N+1); % Eingangsvektor (x[k],x[k-1],..,x[k-N+1])
  y      = x'*w;          % Filterausgang
  e      = D(i)-y;        % Fehler      
  w      = w+mu*e*x;      % Aufdatierung der Filterkoeffizienten (3.15)

  E(i)   = e; 
  DD(i)  = y;

end; 

calc=toc; % Stopuhr angehalten



