%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulation Nr. 5 
%         
%         Funktion:
%         Hauptprogramm
%
%	  author:  Markus Hofbauer
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  s5_calc.m
%
%
% Startfile:  sim5.m
%
% Hauptfile:  s5_calc.m
% (wird aufgerufen)
%
% Benoetigte m-Files: im Verzeichnis sim5
%
%-------------------------------------------------------------------
%===================================================================




%===================================================================
% Vorbereitungen
%===================================================================

% message 
pause(0);                                  % pause(0) bewirkt eine
set(htmess,'String',message_sim_lau_vor);  % augenblickliche Ausfuehrung

%-------------------------------------------------------------------
% Lesen der Eingabeparameter
%------------------------------------------------------------------- 

p2=str2num(get(h2,'string'));
p3=str2num(get(h3,'string'));
p4=str2num(get(h4,'string'));
p5=str2num(get(h5,'string'));
p6=str2num(get(h6,'string'));
p7=str2num(get(h7,'string'));
p8=str2num(get(h8,'string'));
pchb1=get(hchbox1,'value');
pchb2=get(hchbox2,'value');

sigma2N=10^(p2/10); 
sn2=sigma2N;
loops=p3;
alpha=p4;
N=p6;
C=p8;
alpha_FLMS=p5;
L=p7;
ar_flag=pchb1;
CL_flag=pchb2;

%------------------------------------------------------------------- 
%  Initialisierungen und Definitionen
%------------------------------------------------------------------- 


% flags
busy_flag=1;
pause_flag=1;
termin_flag=0; 
error_flag=0;
stop_flag=0;
konv_flag=1;        



% FLMS Parameter 
if CL_flag==1              % automatische Wahl von C und L ?
  L = ceil(N/3);           
  C= 2^ceil(log2(L+N-1));  % DFT Laenge
  L=C-N+1;                 % Blockverschiebung
  set(h7,'string',num2str(L))
  set(h8,'string',num2str(C))
  pause(0)
end
N_FLMS=C-L+1;               % Anzahl Gewichte FLMS
mu_FLMS= 0.8* alpha_FLMS ;  % Schrittweite FLMS 
begin=ceil(C/L)-1;          % erster Blockindex 
adaptstart=(begin+1)*L;     

% Signallaengen
%len1    = 24000;                % Laenge der Signale, wird in OK.m gesetzt
len2   = len1-adaptstart-L+1 ;   % Plotlaenge 
len3   = 2000 ; %round(len2/2);  % Mittelungslaenge fuer Jinf

numblk = floor(len1/L);          % Anzahl Bloecke FLMS 

%  Schrittweite LMS
mu=alpha * 0.8*1/N;              % angepasst an N


% Parameter Eingangssignal
sigma2Xnoise =   1.0;         % Varianz von x[.]: Rauschleistung

N_stat= 4096;                 % Parameter fuer calc_x.m

% Laden der Systemantwort
if w_system_flag==0
  load w_system_1500;  
else  
  load w_system_700; 
end  

b = w_system ; a = [1];      % da w_system FIR ist

% Laden der AR-Koeffizienten 16. Ordnung
load ar_koeff16e;
ar_koeff=ar_koeff16e;


e2_LMS=zeros(len2,loops) ;     % Fehlerquadrat LMS
e2_FLMS=zeros(len2,loops) ;    % Fehlerquadrat RLS
w_start=zeros(N,1);            % Startwerte Filterkoeffizienten 

% Ausgabe in IO-Fenster
set(hta1,'String',num2str(N)); 
set(hta2,'String',num2str(N_FLMS));
set(hta4,'String',num2str(numblk));
pause(0);


format compact;

%------------------------------------------------------------------- 
% Test auf Gueltigkeit der Eingabe
%------------------------------------------------------------------- 

if p2>10 | p3 < 1 | p4 < 0 | p5< 0 | p6>N_sys | p6<1 | p7<1 | p8<1 | (L+1) > C 
 set(htmess,'String',message_err); error_flag=1;
end 


%===================================================================
% Loop 
%===================================================================

if error_flag==0;        % falls gueltige Eingabe start loop
 

for i=1:loops            % Loop ueber Realisationen

  pause(0); 
  if stop_flag==1  stop_b ; return ; end       % stop ?
  pause(0);
  set(htmess,'String',message_sim_lau);        % message
  set(hta3,'String',num2str(i));               % message

%-------------------------------------------------------------------
% Generierung der Signale
%-------------------------------------------------------------------
 
  [x,d,ws,norm]=signal_ar(len1,sigma2N,b,a,ar_flag,ar_koeff); 
   % x: Eingangssignal
   % d: erwuenschtes Signal
   % ws: Systemstossantwort
   % Generierung Signalvektoren
  
%-------------------------------------------------------------------
% Aufruf FLMS - Algorithmus
%-------------------------------------------------------------------     
  pause(0); 
  set(htmess,'String',message_sim_lau_flms); 
  pause(0);

  [e_FLMS,w_FLMS,dd_FLMS,calc_FLMS,PX]=flms(mu_FLMS,N_FLMS,C,L,x,d,w_start);  
    % e   : Fehlersignal
    % w   : Gewichtsvektor nach Adaptionsende
    % dd  : Filterausgangssignal, Schaetzung von d
    % calc: Rechenzeit
    % Px  : Schaetzung des Leistungsdichtespektrums vom x
    
%-------------------------------------------------------------------
% Aufruf LMS - Algorithmus
%-------------------------------------------------------------------
  pause(0); 
  if stop_flag==1  stop_b ; return ; end  
  set(htmess,'String',message_sim_lau_lms); 
  pause(0);

  [e_LMS,W,w_LMS,dd_LMS,calc_LMS]=lms_2(mu,N,x,d,w_start,adaptstart);     
    % e   : Fehlersignal
    % w   : Gewichtsvektor nach Adaptionsende
    % dd  : Filterausgangssignal, Schaetzung von d
    % calc: Rechenzeit
 
% Fehlerquadrat LMS
e2_LMS(:,i)=e_LMS(adaptstart:len1-L).*e_LMS(adaptstart:len1-L);     
% Fehlerquadrat FMS
e2_FLMS(:,i)=e_FLMS(adaptstart:len1-L).*e_FLMS(adaptstart:len1-L); 

end;
  
%===================================================================
% Auswertung
%===================================================================

pause(0); 
set(htmess,'String',message_sim_lau_ausw); 
pause(0);
 
J_LMS=mean(e2_LMS',1);     % Ensemblemittelwert des quadr. Fehlers -> Lernkurve
J_FLMS=mean(e2_FLMS',1);       

% zusaetzliche zeitliche Glaettung der Lernkurven mit einem 
% exponentiellen Fenster aus Darstellungsgruenden
ga_LMS=0.1;                        % Glaettungsfaktor
ga_FLMS=0.1;                       % Glaettungsfaktor
J_LMS=expwin2(J_LMS',ga_LMS);
J_FLMS=expwin2(J_FLMS',ga_FLMS);


%-------------------------------------------------------------------
% Berechnung der Statistik und Jmin
%-------------------------------------------------------------------


if ar_flag==1                         % Eingang AR-Prozess
 [R,rx]=calc_R2(1,ar_koeff,N,N_stat); 
         % R: Autokorr. Matrix; rx: Autokorr. Funktion
 ryx=calc_ryxb(ws',1,rx,N_stat);
 p=ryx(1:N)';                         % p: Kreuzkorrelationsvektor
 ry=calc_ryb(ws',1,rx,N_stat);        % ry:  Autokorr. Funktion von d'
 sd2=ry(1)+sigma2N;                   % sd2: Varianz von d
 Jmin  = abs(sd2 -p'*ws(1:N));            
            % eigentlich: Jmin  = sd2 -p'* w0;
	    % Um w0 zu berechnen, muesste inv(R) bestimmt werden. Dies 
	    % ist bei NxN=1000x1000 zu aufwendig, so dass hier
	    % naeherungsweise w0=ws(1:N) gesetzt wird.
	  
else                                  % Eingang weiss
 rx=zeros(1,N_stat) ; rx(1)=1;
 Jmin = abs((sn2+sum(ws(N+1:length(ws)).^2)));
 sd2=1+sigma2N;
end;

pause(0);
if stop_flag==1  stop_b ; return ; end   % stop ?

%-------------------------------------------------------------------
% Grenzwerte der Lernkurven, Fehleinstellung, ERLE
%-------------------------------------------------------------------

% Abschaetzung von J[ke], LMS
Jinf=mean(J_LMS(len2-len3:len2));          

if Jinf>10*sd2 | isnan(Jinf)        % keine Konvergenz, Schrittweite 
  konv_flag=0;                      % mu zu gross !
  Jinf=sd2;
end
 
% Abschaetzung  von J[ke], FLMS
Jinf2=mean(J_FLMS(len2-len3:len2));   

% Fehleinstellung LMS
M=(Jinf-Jmin)/Jmin;
if M > 10 Mplot=[' > 1000 %'] ; else  Mplot=[sprintf('%1.1f',100*M),'%']; end;

% Fehleinstellung FLMS
M2=(Jinf2-Jmin)/Jmin;
if M2 > 20 M2plot=[' > 1000 %'] ; else  M2plot=[sprintf('%1.1f',100*M2),'%']; end;

% ERLE
erle_LMS=db(sd2/Jinf); 
erle_FLMS=db(sd2/Jinf2);
erle_FLMS_db=[sprintf('%1.1f',erle_FLMS),' dB'];

% Plotparameter 
if Jinf <= Jmin   Jinf=Jmin* 1.00000001 ; end
if Jinf2 <= Jmin  Jinf2=Jmin*1.00000001 ; end
if sn2==0 sn2db='-\infty';  else sn2db=10*log10(sn2) ; end 
if Jmin==0 Jmindb='-\infty'; else Jmindb=10*log10(Jmin) ; end 


%-------------------------------------------------------------------
% Berechnung des Systemfehlermasses
%-------------------------------------------------------------------

% im Zeitbereich
w_FLMSplot= [w_FLMS;zeros(length(ws)-N,1)];
dw2=ws- [w_LMS;zeros(length(ws)-N,1)];
dw3=ws- w_FLMSplot(1:length(ws));

dw2_db=db(sum(dw2.^2)/sum(ws.^2));
dw3_db=db(sum(dw3.^2)/sum(ws.^2));

% im Frequenzbereich
WS=abs(fft(ws,8000));
DW2_db=db((abs(fft(dw2,8000)).^2)./WS.^2);
DW3_db=db((abs(fft(dw3,8000)).^2)./WS.^2);



%===================================================================
% Graphik
%===================================================================

pause(0);  
set(htmess,'String',message_sim_lau_gra);    % message
if stop_flag==1  stop_b ; return ; end       % stop ?


%-----------------------------------------------------------------
% AKF und Spektrum von x
%-----------------------------------------------------------------

% figur(2)

f2=figure(2); clf; 
if first_time set(f2,'position', [8 571 400 369]); end; 

subplot(211); 
  rxbs=[rx(lge(rx):-1:2) rx]; 
  plot([-200:200],rxbs(N_stat-200:N_stat+200)); 
  axis([-200 200 -1 1.2]) ;grid;  
  title('AKF von x') ; 
  xlabel('k'); ylabel('rx'); 
  subplot(212); 
  Px=abs(fft(rxbs,8000)); 
  plot(db(Px(1:4000))) ;grid; 
  xlabel('                                          f                                    [Hz]'); 
  ylabel('Sx     [dB]'); 
  title('Leistungsdichtespektrum von x'); 
  axis([0 4000 -30 20])

%-------------------------------------------------------------------
% Lernkurven
%-------------------------------------------------------------------

pause(0);  
if stop_flag==1  stop_b ; return ; end    % stop ?

% figur(2)

f3=figure(3); clf; 
if first_time set(f3,'position', [589 96 686 843]); end;

% subplot 1, LMS-Lernkurve 
subplot('position',[0.13 0.62 0.77 0.32]);
  plot(db(J_LMS)); grid;  xlabel('k')
  axis([0 len2 db(Jmin/10)  db(sd2*10)]);
  ax1=axis; yrange=ax1(4)-ax1(3);
  title(['LMS: Lernkurve J[k] =  E[ e[k]^2 ]   (Schaetzung aus ',num2str(loops),' Realisationen)']);
  plotypos1=max(db(Jmin)+0.06*yrange,db(Jinf));
  plotypos1b=max(db(Jmin)+0.01*yrange,db(Jinf));
  hold on;
  plot(plotypos1b*ones(1,len2),'g');
  plot(db(sd2*ones(1,len2)),'r');
  plot(db(Jmin*ones(1,len2)),'r');
  text(-len2*0.08,ax1(4)+yrange*0.05,'[dB]') 
  text(-len2*0.15,plotypos1,'J[k_e]')
  text(-len2*0.15,db(Jmin),'J_{min}')
  text(1.01*len2,plotypos1,[sprintf('%1.1f',10*log10(Jinf)),' dB'])
  text(-len2*0.15,db(sd2),'J[0] = \sigma_d^2')
  text(1.01*len2,db(sd2),[sprintf('%1.1f',10*log10(sd2)),' dB'])
  text(1.01*len2,db(Jmin),[sprintf('%1.1f',10*log10(Jmin)),' dB'])

% subplot 2 RLS-Lernkurve 
subplot('position',[0.13 0.2 0.77 0.32]);
  plot(db(J_FLMS)); grid; xlabel('k')
  axis([0 len2 db(Jmin/10)  db(sd2*10)]);
  ax1=axis; yrange=ax1(4)-ax1(3);
  title(['FLMS : Lernkurve J[k] = E[ e[k]^2 ]   (Schaetzung aus ',num2str(loops),' Realisationen)']);
  plotypos2=max(db(Jmin)+0.06*yrange,db(Jinf2));
  plotypos2b=max(db(Jmin)+0.01*yrange,db(Jinf2));
  hold on;
  plot(plotypos2b*ones(1,len2),'g');
  plot(db(sd2*ones(1,len2)),'r');
  plot(db(Jmin*ones(1,len2)),'r');
  text(-len2*0.08,ax1(4)+yrange*0.05,'[dB]') 
  text(-len2*0.15,plotypos2,'J[k_e]')
  text(-len2*0.15,db(Jmin),'J_{min}')
  text(1.01*len2,plotypos2,[sprintf('%1.1f',10*log10(Jinf2)),' dB'])
  text(-len2*0.15,db(sd2),'J[0] = \sigma_d^2')
  text(1.01*len2,db(sd2),[sprintf('%1.1f',10*log10(sd2)),' dB'])
  text(1.01*len2,db(Jmin),[sprintf('%1.1f',10*log10(Jmin)),' dB'])
 
% Ausgabe der Kennwerte
  su=subplot('position',[0.05 0.01 0.9 0.12]);
  set(su,'ytick',NaN); set(su,'xtick',NaN); set(su,'box','on');
  set(su,'color',[0.75 0.75 0.75]);
  text(0.05,0.75,['\sigma_n^2 =  ',sprintf('%1.1f',sn2db),' dB'])
  text(0.4,0.75,['J_{min} (fuer N = ',num2str(N),') =  ',sprintf('%1.1f',Jmindb),' dB'])
  text(0.8,0.75,['J_{ex} = J[k_e] - J_{min}'])
  text(0.05,0.45,['M_{LMS} = J_{ex}/J_{min} :  ',Mplot])
  text(0.4,0.45,['M_{FLMS} = J_{ex}/J_{min} :  ',M2plot])
  text(0.05,0.1,['ERLE_{FLMS} = \sigma_d^2 / J[k_e] = ',erle_FLMS_db])


%-------------------------------------------------------------------
% Vergleich der Filtergewichte mit der Systemantwort
%-------------------------------------------------------------------

pause(0);  
if stop_flag==1  stop_b ; return ; end    % stop ?

% figur(4)

f4=figure(4); clf; 
if first_time set(f4,'position', [418 8 560 728]);  end;

% subplot 1, Vergleich mit der Systemantwort 
subplot(211)
  axis([1 lge(ws)+50 1.2*min([ws;w_LMS]) 1.2*max([ws;w_LMS])])
  ax=axis;
  yrange1=(ax(4)-ax(3)) ;
  xrange1=(ax(2)-ax(1)) ;
  patch([ax(1) ax(1) N N ax(1)],[ax(3) ax(4) ax(4) ax(3) ax(3)],[0.9 0.9 0.9])
  hold on;
  plot(ws,'b')
  plot(w_LMS,'r')
  plot(w_FLMS,'g')
  plot(ws,'b')
  line([N-0.03*xrange1 N],(ax(4)-0.1*yrange1)*[1 1]); text(N-0.2*xrange1,(ax(4)-0.1*yrange1),'identifizierter')
  text(N-0.2*xrange1,(ax(4)-0.2*yrange1),'Teil')
  title('Vergleich der Filter mit der Systemimpulsantwort')
  xlabel('Index Koeffizienten ')
  ylabel('w')
  legend('System','LMS','FLMS',4)

% subplot 2, Abweichung von der Systemantwort  
su=subplot(212) ; 
  ps=get(su,'position'); set(su,'position',[ps(1) 1.2*ps(2) ps(3) ps(4)]);
  axis([1 lge(ws)+50 1.2*min([dw2;dw3]) 1.2*max([dw2;dw3])])
  ax=axis;
  patch([ax(1) ax(1) N N ax(1)],[ax(3) ax(4) ax(4) ax(3) ax(3)],[0.9 0.9 0.9])
  hold on;
  plot(dw2,'r')
  plot(dw3,'g')
  title('Abweichung der Filter von der Systemantwort')
  xlabel('Index Koeffizienten ')
  ylabel('\Delta w')
  legend('LMS','FLMS',4)

% Ausgabe des System-Fehler-Masses (Zeitbereich)
su=subplot('position',[0.05 0.01 0.9 0.05]);
set(su,'ytick',NaN); set(su,'xtick',NaN); set(su,'box','on');
set(su,'color',[0.75 0.75 0.75]);
text(0.02,0.45,'System-Fehler-Mass:')
text(0.35,0.4,['\Deltaw_{dB (LMS)}   = ',sprintf('%1.1f',dw2_db),' dB']);
text(0.7,0.4,['\Deltaw_{dB (FLMS)}   = ',sprintf('%1.1f',dw3_db),' dB']);

%-------------------------------------------------------------------
% Filter im Frequenzbereich: W_System und W_FLMS und Systemfehlermass
%-------------------------------------------------------------------

pause(0);  
if stop_flag==1  stop_b ; return ; end    % stop ?

f5=figure(5);  clf;
if first_time set(f5,'position', [419 478 561 465]); end;

% subplot 1, Vergleich mit der Systemantwort 
subplot(211)
  w_FLMSplot= [w_FLMS;zeros(length(ws)-N,1)];
  plot(db(WS),'b')
  hold on;
  plot(db(abs(fft(w_LMS,8000))),'r')
  plot(db(abs(fft(w_FLMSplot(1:lge(ws)),8000))),'g')
  plot(db(WS),'b')
  grid
  axis([0 4000 -30 10]);
  title('Filter im Frequenzbereich:    W_{System} ,  W_{LMS} und W_{FLMS}')
  xlabel('                                                          f                                                        [Hz]'); 
  ylabel('W        [dB]')
  legend('W_{System}','W_{LMS}','W_{FLMS}',4)

% subplot 2, Abweichung von der Systemantwort (Systemfehlermass)
subplot(212) 
  plot(DW2_db,'r');
  hold on; grid; 
  plot(DW3_db,'g');
  title('System-Fehler-Mass im Frequenzbereich:   \DeltaW_{dB}')
  xlabel('                                                          f                                                        [Hz]'); 
  ylabel('\Delta W_{db}           [dB]')
  legend('LMS','FLMS',4)
  ax=axis; axis([0 4000 ax(3) 10]);


%-------------------------------------------------------------------
% Frequenzabhaengige  Schrittweite mu(j) = alphaFLMS / PX(j)
%-------------------------------------------------------------------

pause(0);  
if stop_flag==1  stop_b ; return ; end    % stop ?

f6=figure(6); clf;

if first_time set(f6,'position', [818 10 455 358]);  end;

plot(-db(PX(1:C/2)/alpha_FLMS)+db(C))
ax=axis; axis([0 C/2 ax(3) ax(4)]);
title('FLMS-Algorithmus:  frequenzabhaengige Schrittweite  \mu_j = \alpha_{FLMS} / Px_j')
grid
xlabel('                                     j   (DFT Koeffizient)                      C/2') 
ylabel('\mu_j          [dB]')


%===================================================================
% I/0 Fenster, Ausgabe 
%===================================================================

set(htmess,'String',message_sim_abg); 
set(hta5,'String',sprintf('%1.2f',calc_LMS/calc_FLMS));

first_time=0;

end;

%-------------------------------------------------------------------
% Abschluss
%-------------------------------------------------------------------

busy_flag=0;

if konv_flag==0  set(htmess,'String',message_konv); end;
if termin_flag==1; terminate; end

%============================== end ================================

