%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulation 5 
%         
%         Funktion: 
%         Auswahl der Systemimpulsantwort
%         
%
%-------------------------------------------------------------------

%
%	  author:  Markus Hofbauer,
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  set_wsystem.m
%
% Startfile:  sim5.m
%
%-------------------------------------------------------------------
%===================================================================



if busy_flag==1
   pause(0) 
   set(htmess,'String',message_sim_start);  
   pause(0) 
else
   busy_flag2=1;
  
  
%-------------------------------------------------------------------
% Koordinatendefinitionen des Fensters
%-------------------------------------------------------------------

% Fenster

wb2=550; wh2=350;             %   Breite, Hoehe
iowinpos2=[50 200 wb2 wh2];   %   Position

fa2=20;                       % Feldabstand vertikal

%-------------------------------------------------------------------
% I/O Figur Initialisierung
%-------------------------------------------------------------------

f_IO2=figure(20);
set(f_IO2,'resize','off','numbertitle','off','name','Systemimpulsantwort','Position',iowinpos2);

ha2=axes ; axis off;
set(ha2,'position',[0 0 1 1],'xlim',[0 wb2],'ylim',[0 wh2]);
patch([5 wb2-5 wb2-5 5 5],[5 5 wh2-5  wh2-5 5],[0.75 0.75 0.75])

%-------------------------------------------------------------------
% Text und Eingabe
%----------------------------------------------------------------


% Text
hwt1=text(100,wh2-30,'Wahl der Laenge der Systemimpulsantwort');
set(hwt1,'color',[1 1 0],'FontSize',1.3*fontsi);

text(20,wh2-70,['Systemimpulsantwort: LRMI gemessen in einem Seminarraum.']);


text(20,wh2-70-fa2,'Wahl der Anzahl Gewichte, die bei der Simulation beruecksichtigt werden sollen:');

text(20,wh2-110-fa2-kor,['Default: Verwendung der ersten  N_{system} = 1500 Gewichte der LRMI:']);

text(20,wh2-180-fa2,'Falls Ihr Prozessor nur eine beschraenkte Rechenleistung bietet, kann zur Reduktion der')
text(20,wh2-180-2*fa2-kor,'Simulationsdauer eine kuerzere LRMI (N_{system} = 700) verwendet werden.')
text(20,wh2-180-3*fa2,'(MATLAB Studentenversion: ebenfalls diese Option waehlen. Und: # Realisationen = 1 ! )');

% Eingabe
%hwt2=uicontrol(f_IO2,'Style','edit','Position',[110 wh2-110-kor-5*fa2 fb fh],'string',num2str(N_sys),'ForegroundColor',[1 1 0]);
%  text(20, wh2-110-5*fa2,'N_{system} : ');
%  text(200, wh2-110-5*fa2,'256 \leq N_{system} \leq 1500 ');
  
  
%text(20,wh2-110-7*fa2,'Falls N_{system} < 500, wird als Systemimpulsantwort eine LRMI verwendet,');
%text(20,wh2-110-8*fa2,'die in einem PKW gemessen worden ist (N_{system} = 256)');


%-------------------------------------------------------------------
% buttons
%-------------------------------------------------------------------

%  checkbox 1500

hchboxw1 = uicontrol(f_IO2,'Position',[130,wh2-170 fb fh],'Style','checkbox','value',pchbox1winit,'ForegroundColor',[1 1 0],'callback','chbox1500');
text(20, wh2-170-kor+fh/2,'N_{system} = 1500 :'); 

%  checkbox 700

hchboxw2 = uicontrol(f_IO2,'Position',[130,wh2-280 fb ...
      fh],'Style','checkbox','value',pchbox2winit,'ForegroundColor',[1 1 0],'callback','chbox700');
text(20, wh2-280-kor+fh/2,'N_{system} = 700 :'); 

% Abbruch
uicontrol(f_IO2,'Style','pushbutton','Position',[wb2-110,30 100 ...
      23],'String','Abbruch','CallBack','close(f_IO2); busy_flag2=0; ','ForegroundColor',[1 1 0] );   

% OK
uicontrol(f_IO2,'Style','pushbutton','Position',[wb2-215,30 100 23],'String','OK','CallBack','OK','ForegroundColor',[1 1 ...
      0] );  

end 
