%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulationen  
%         
%         [X,D,ws,norm]=signal_ar(len,sigma2N,b,a,ar_flag,ar_koef)

%
%         Erzeugung der Signale X,D
%         Eingangssignal: weisses Rauschen oder  AR-Prozess
%                         AR-Prozess       falls ar_flag = 1
%         Erwuenschtes Signal d = Systemausgang + Messrauschen
%
%         X          = Filtereingang X[.]
%         D          = erwuenschtes Signal D[.]
%         ws         = Systemstossantwort (gegeben durch b,a)
%         norm       = Normierung des Systemfilters (s.u.)
%         len        = Signallaenge
%         sigma2N    = Varianz weisses Messrauschen
%         b,a        = Filterkoeffizienten des Systemfilters
%         ar_flag    = 0: x: weisses Rauschen
%                    = 1: x: AR-Prozess 
%
%         ar_koef    = LPC Koeffizienten zur Erzeugung eines AR-Prozesses
%                      mit sprachtypischem Spektrum 

%-------------------------------------------------------------------

%
%	  author:  Markus Hofbauer
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  signal_ar.m
%
% Startfile:  sim5.m
%
%-------------------------------------------------------------------
%===================================================================


function [X,D,ws,norm]=signal_ar(len,sigma2N,b,a,ar_flag,ar_koef)

% Eingangssignal x 
X = randn(len,1);    % weisses Rauschen

if ar_flag==0
  X=X;
else
  X= filter([1],ar_koef,X);    % AR-Prozess
end
normX=sqrt(var(X));  % Normierung der Eingangsleistung auf var(X)=1
X=X/normX;    

% Systemausgang Ys 
Ys = filter(b,a,X);   %  Systemausgang Ys                          
normYs=sqrt(var(Ys)); % Normierung des Systemausgangs auf var(Ys)=1 (*)
Ys=Ys/normYs;

% weisses Messrauschen
N = sqrt(sigma2N)*randn(len,1);      

% erwuenschtes Signal d 
D = Ys+N;   % d = Systemausgang + Messrauschen


norm=1/normYs;

% Systemstossantwort ws
 %ntaps = 1500;                 % Laenge der Systemstossantwort 
 %dirac=[1 zeros(1,ntaps-1)];   % Dirac-Stoss
 %ws=filter(b,a,dirac)'* norm;  % Filterung mit Dirac-Stoss
                                % und Normierung mit norm
			        % damit var(Ys)=1, siehe (*)
 % Spezialfall FIR-Filter (a=1):			      
 ws=b*norm;
