%===================================================================
%-------------------------------------------------------------------
%
%         Adaptive Filter 
%
%         Simulation Nr. 5  
%         
%         Funktion:
%         Einrichten des gui Ein- und Ausgabefensters
%         und Aufruf des Hauptprogramms
%
%	  author:  Markus Hofbauer,
%                  ISI, ETH Zuerich (Switzerland)
%
%         created: 7/2000  
%         
%
%-------------------------------------------------------------------
%
% File     :  sim5.m
%
%
% Startfile:  sim5.m
%
% Hauptfile:  s5_calc.m
% (wird aufgerufen)
%
% Benoetigte m-Files: im Verzeichnis sim5
%
%-------------------------------------------------------------------
%===================================================================




%===================================================================
% Initialisierung und Definitionen
%===================================================================

% close/clear all

figure(1); close 1;
close all; clear;


% Definition globaler Variablen

global stop_flag
stop_flag=0;
global busy_flag
busy_flag=0;
global termin_flag
termin_flag=0;
global pause_flag;
pause_flag=1;
global busy_flag2;
busy_flag2=0;

w_system_flag=0;
first_time=1;

%-------------------------------------------------------------------
% Koordinatendefinitionen des IO-Fensters
%-------------------------------------------------------------------

% IO-Fenster
wb=400; wh=575;           %   Breite, Hoehe
iowinpos=[10 10 wb wh];   % Position

% Eingabefelder

fb=60;                       % Feldbreite
fh=20;                       % Feldhoehe wird noch veraendert
fa=30;                       % Feldabstand vertikal
sp1=20; sp2=180 ; sp3=245;   % 1,2,3. Spalte
re1=wh-80; re2= 0.28*wh;     % 1. und 2. Zeile (Eingabe und Ausgabe)
kor=5;                       % Korrektur 

%-------------------------------------------------------------------
% I/O Figur Initialisierung
%-------------------------------------------------------------------

f_IO=figure('resize','off','numbertitle','off','name','I/0','Position',iowinpos);
ha=axes ; axis off;
set(ha,'position',[0 0 1 1],'xlim',[0 wb],'ylim',[0 wh]);
fontsi=get(ha,'fontsize');
patch([0 wb wb 0 0],[0 0 re2  re2 0],[0.75 0.75 0.75])
patch([0 wb wb 0 0],[re2+50 re2+50  re1 re1 re2+50],[0.75 0.75 0.75])
patch([sp3+45 wb-5 wb-5 sp3+45  sp3+45],[re2+65 re2+65 re2+3*fa+50  re2+3*fa+50 re2+65],[0.75 0.75 0.75])

%===================================================================
%  Definition der Ein- und Ausgabeparameter
%===================================================================

% aufgerufenes Hauptprogramm
callfile='s5_calc';        % wird von start aufgerufen 

%-------------------------------------------------------------------
%  Eingabeparameter
%-------------------------------------------------------------------

pchb1str='x[k]         weiss / farbig: ';  % label Parameter 1
pchbox1init=0  ;                           % Initwert 
pchb1message='' ;                          % Zusatz label

p2str='\sigma^2_n : ';  
p2init=-40  ;
p2message='dB  ( < 0 ) ' ; 

p3str='# Realisationen : ';  
p3init=3  ;
p3message=''; 

p4str='\alpha_{LMS} :';  
p4init=1  ;
p4message='' ; 

p5str='\alpha_{FLMS} :';  
p5init=1  ;
p5message='' ; 

p6str='N :';  
p6init=1500  ;
p6message='' ; 

p7str='L :';  
p7init=549  ;
p7message='' ; 

p8str='C :';  
p8init=2^11  ;
p8message='' ; 

p8bstr='Wahl von N_{system}';  
p8binit=1500;
p8bstr2='N_{system} :'; 
N_sys=p8binit;

pchb2str='auto Wahl von C, L';  
pchbox2init=1  ;
pchb2message='' ; 

p10str='Wahl der Systemimpulsantwort: ';  
p10init=1500;

len1    = 24000;  

% set_wsystem checkboxes
pchbox1winit=1;
pchbox2winit=0;


%-------------------------------------------------------------------
% Ausgabeparameter
%-------------------------------------------------------------------

pa1str='N_{LMS} = N : ';  
pa1init='' ;

pa2str='N_{FLMS}= C - L +1 : ';  
pa2binit=''  ;

pa3str='Realisation Nr. : ';  
pa3init=''  ;

pa4str='Anzahl Bloecke : ';  
pa4init=''  ;

pa5str='Verhaeltnis Rechenzeit LMS / FLMS :  ';  
pa5init=''  ;

%-------------------------------------------------------------------
% messages
%-------------------------------------------------------------------

message_init='';
message_err='ungeeignete Eingabe  !';
message_konv='keine Konvergenz, \mu zu gross !';
message_sim_lau='Simulation laeuft : ';
message_sim_lau_vor='Simulation laeuft : Vorbereitung';
message_sim_lau_lms='Simulation laeuft : LMS-Alg.';
message_sim_lau_rls='Simulation laeuft : RLS-Alg.';
message_sim_lau_flms='Simulation laeuft : FLMS-Alg.';
message_sim_lau_ausw='Simulation laeuft : Auswertung';
message_sim_lau_gra='Simulation laeuft : Graphik';
message_sim_stop='Simulation gestoppt';
message_sim_wstop='Simulation wird gestoppt';
message_sim_abg='Simulation abgeschlossen';
message_sim_start='Simulation laeuft bereits';
message_sim_start2='Wahl von N_{system} beenden';

%===================================================================
% gui mit den definierten Ein- und Ausgabeparametern
%===================================================================

%-------------------------------------------------------------------
% buttons
%-------------------------------------------------------------------

%% Start
hstart=uicontrol(f_IO,'Style','pushbutton','Position',[wb-210 re1+40 100 ...
      23],'String','Start','CallBack','start5','ForegroundColor',[1 1 0] );   


%%  Ende
hterm=uicontrol(f_IO,'Style','pushbutton','Position',[wb-105 re1+15 100 ...
      23],'String','Ende','CallBack','terminate','ForegroundColor',[1 1 ...
      0] );  

%% Stop
hstop=uicontrol(f_IO,'Style','pushbutton','Position',[wb-105 re1+40 100 ...
      23],'String','Stop','CallBack','stop_a;','ForegroundColor',[1 1 ...
      0] );  

%% Init Werte
hinit=uicontrol(f_IO,'Style','pushbutton','Position',[wb-210 re1+15 100 ...
      23],'String','Init Werte','CallBack','setinitval','ForegroundColor',[1 ...
      1 0] );  
 
%-------------------------------------------------------------------
% Eingabefelder
%-------------------------------------------------------------------

% Eingabe
 heing=uicontrol(f_IO,'Style','text','Position',[sp1 re1+40 100 ...
       23],'string','Eingabe:','FontSize',1.5*fontsi,'ForegroundColor',[1 1 0]);
 
% checkbox1
hchbox1 = uicontrol(f_IO,'Position',[sp2 re1-1*fa fb ...
      fh],'Style','checkbox','value',pchbox1init,'ForegroundColor',[1 1 0]);
  text(sp1,re1-1*fa+fh/2,pchb1str);

  % parameter 2
h2=uicontrol(f_IO,'Style','edit','Position',[sp2  re1-2*fa fb ...
      fh],'string',num2str(p2init),'ForegroundColor',[1 1 0]);
   text(sp1,re1-2*fa+fh/2-kor,p2str);
   ht2=text('Position',[sp3 re1-2*fa+fh/2]);
   set(ht2,'String',p2message);

% parameter 3
h3=uicontrol(f_IO,'Style','edit','Position',[sp2  re1-3*fa fb ...
      fh],'string',num2str(p3init),'ForegroundColor',[1 1 0]);
   text(sp1,re1-3*fa+fh/2,p3str);
   ht3=text('Position',[sp3 re1-3*fa+fh/2]);
   set(ht3,'String',p3message);

% parameter 4
h4=uicontrol(f_IO,'Style','edit','Position',[sp2  re1-4*fa fb ...
      fh],'string',num2str(p4init),'ForegroundColor',[1 1 0]); 
  text(sp1,re1-4*fa+fh/2-kor,p4str);
  ht4=text('Position',[sp3 re1-4*fa+fh/2]);
  set(ht4,'String',p4message);

% parameter 5
h5=uicontrol(f_IO,'Style','edit','Position',[sp2  re1-5*fa fb ...
      fh],'string',num2str(p5init),'ForegroundColor',[1 1 0]); 
  text(sp1,re1-5*fa+fh/2-kor,p5str);
  ht5=text('Position',[sp3 re1-5*fa+fh/2]);
  set(ht5,'String',p5message);

% parameter 6
h6=uicontrol(f_IO,'Style','edit','Position',[sp2  re1-6*fa fb ...
      fh],'string',num2str(p6init),'ForegroundColor',[1 1 0]); 
  text(sp1,re1-6*fa+fh/2,p6str);
  ht6=text('Position',[sp3 re1-6*fa+fh/2]);
  set(ht6,'String',p6message);

  
% parameter 7
h7=uicontrol(f_IO,'Style','edit','Position',[sp2  re1-7*fa fb ...
      fh],'string',num2str(p7init),'ForegroundColor',[1 1 0]); 
  text(sp1,re1-7*fa+fh/2,p7str);
  ht7=text('Position',[sp3 re1-7*fa+fh/2]);
  set(ht7,'String',p7message);

% parameter 8  
  h8=uicontrol(f_IO,'Style','edit','Position',[sp2  re1-8*fa fb ...
      fh],'string',num2str(p8init),'ForegroundColor',[1 1 0]); 
  text(sp1,re1-8*fa+fh/2,p8str);
  ht8=text('Position',[sp3 re1-8*fa+fh/2]);
  set(ht8,'String',p8message);
  

% parameter 8b    
  
hsys=uicontrol(f_IO,'Style','pushbutton','Position',[sp3+67  re1-8*fa fb ...
      fh],'String','','CallBack','set_wsystem','ForegroundColor',[1 1 0] );   
text(sp3+50,re1-8*fa+fh+1.5*kor,p8bstr); 
text(sp3+50,re1-9*fa+fh-2.0*kor,p8bstr2); 
ht8b=text('Position',[sp3+100,re1-9*fa+fh-1*kor]);
set(ht8b,'String',p8binit);



% checkbox2
hchbox2 = uicontrol(f_IO,'Position',[sp2 re1-9*fa fb ...
      fh],'Style','checkbox','value',pchbox2init,'ForegroundColor',[1 1 0]);
  text(sp1,re1-9*fa+fh/2,pchb2str); 
  
handle_list=[h2 p2init ; h3 p3init ; h4 p4init; h5 p5init; h6 p6init  ; h7 p7init ;  h8 p8init ;hchbox1 pchbox1init; hchbox2 pchbox2init];

%-------------------------------------------------------------------  
% Ausgabefelder
%-------------------------------------------------------------------

uicontrol(f_IO,'Style','text','Position',[sp1 re2+10 100 ...
      23],'string','Ausgabe:','FontSize',1.5*fontsi,'ForegroundColor',[1 0 0]);

% message
htmess=text('Position',[sp2 re2+15]);
set(htmess,'String',message_init);

% parameter 1
text(sp1,re2-2*fa+fh/2-kor,pa1str);
  hta1=text('Position',[sp2 re2-2*fa+fh/2]);
  set(hta1,'String',num2str(pa1init));

% parameter 2
text(sp1,re2-3*fa+fh/2-kor,pa2str);
  hta2=text('Position',[sp2 re2-3*fa+fh/2]);
  set(hta2,'String',num2str(pa1init));

% parameter 3  
text(sp1,re2-1*fa+fh/2,pa3str);
  hta3=text('Position',[sp2 re2-1*fa+fh/2]);
  set(hta3,'String',num2str(pa1init));

% parameter 4  
text(sp1,re2-4*fa+fh/2,pa4str);
  hta4=text('Position',[sp2 re2-4*fa+fh/2]);
  set(hta4,'String',num2str(pa1init));

% parameter 5 
text(sp1,re2-5*fa+fh/2,pa5str);
  hta5=text('Position',[sp3+80 re2-5*fa+fh/2]);
  set(hta5,'String',num2str(pa5init));

%-------------------------------------------------------------------
%
%-------------------------------------------------------------------

set(f_IO,'handlevisibility','off')    % verhindert versehentliches
                                      % zeichnen in I/O Fenster
set_wsystem;

%============================== end ================================
%-------------------------------------------------------------------


